<?php
App::uses('AppController', 'Controller');
class TargetMarketsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('TargetMarket','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'TargetMarket.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->TargetMarket->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->TargetMarket->updateAll(array("TargetMarket.status"=>'0'),array("TargetMarket.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->TargetMarket->updateAll(array("TargetMarket.status"=>'1'),array("TargetMarket.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->TargetMarket->updateAll(array("TargetMarket.show_home"=>'1'),array("TargetMarket.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->TargetMarket->updateAll(array("TargetMarket.show_home"=>'0'),array("TargetMarket.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->TargetMarket->deleteAll(array('TargetMarket.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['TargetMarket']['title']) && $this->data['TargetMarket']['title']!='') $title = $this->data['TargetMarket']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['TargetMarket']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['TargetMarket.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('TargetMarket.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('target_markets', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add TargetMarket'));
		if ($this->request->is('post')) {
			$this->TargetMarket->create();	
			$pre_title_check = $this->TargetMarket->find("count",array("conditions"=>array("TargetMarket.title"=>$this->request->data['TargetMarket']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['TargetMarket']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->TargetMarket->save($this->request->data['TargetMarket'])){
					$this->Session->setFlash(__('Target Market has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Target Market could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Target Market title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit TargetMarket'));
		$this->TargetMarket->id = $id;
		$selected = "";
		
		$driver_detail = $this->TargetMarket->find("first",array("conditions"=>array("TargetMarket.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->TargetMarket->exists()) {
			throw new NotFoundException(__('Invalid target_market'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['TargetMarket']['id']=$id;		
			$pre_title_check = $this->TargetMarket->find("count",array("conditions"=>array("TargetMarket.title"=>$this->request->data['TargetMarket']['title'],"TargetMarket.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->TargetMarket->saveAll($this->request->data['TargetMarket'])) {
					$this->Session->setFlash(__('Target Market has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Target Market could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Target Market title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->TargetMarket->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->TargetMarket->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->TargetMarket->id = $id;
		if (!$this->TargetMarket->exists()) {
			throw new NotFoundException(__('Invalid Target Market'));
		}
		else
		{
			if ($this->TargetMarket->delete()) {
				$this->Session->setFlash(__('Target Market has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Target Market could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
