<?php
App::uses('AppController', 'Controller');
class SearchTypesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('SearchType','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'SearchType.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->SearchType->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->SearchType->updateAll(array("SearchType.status"=>'0'),array("SearchType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->SearchType->updateAll(array("SearchType.status"=>'1'),array("SearchType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->SearchType->updateAll(array("SearchType.show_home"=>'1'),array("SearchType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->SearchType->updateAll(array("SearchType.show_home"=>'0'),array("SearchType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->SearchType->deleteAll(array('SearchType.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['SearchType']['title']) && $this->data['SearchType']['title']!='') $title = $this->data['SearchType']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['SearchType']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['SearchType.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('SearchType.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('search_types', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add SearchType'));
		if ($this->request->is('post')) {
			$this->SearchType->create();	
			$pre_title_check = $this->SearchType->find("count",array("conditions"=>array("SearchType.title"=>$this->request->data['SearchType']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['SearchType']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->SearchType->save($this->request->data['SearchType'])){
					$this->Session->setFlash(__('Search Type has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Search Type could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Search Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit SearchType'));
		$this->SearchType->id = $id;
		$selected = "";
		
		$driver_detail = $this->SearchType->find("first",array("conditions"=>array("SearchType.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->SearchType->exists()) {
			throw new NotFoundException(__('Invalid search_type'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['SearchType']['id']=$id;		
			$pre_title_check = $this->SearchType->find("count",array("conditions"=>array("SearchType.title"=>$this->request->data['SearchType']['title'],"SearchType.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->SearchType->saveAll($this->request->data['SearchType'])) {
					$this->Session->setFlash(__('Search Type has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Search Type could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Search Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->SearchType->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->SearchType->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->SearchType->id = $id;
		if (!$this->SearchType->exists()) {
			throw new NotFoundException(__('Invalid Search Type'));
		}
		else
		{
			if ($this->SearchType->delete()) {
				$this->Session->setFlash(__('Search Type has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Search Type could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
