<?php
App::uses('AppController', 'Controller');
class OriginalEmailsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('OriginalEmail','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'OriginalEmail.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->OriginalEmail->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->OriginalEmail->updateAll(array("OriginalEmail.status"=>'0'),array("OriginalEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->OriginalEmail->updateAll(array("OriginalEmail.status"=>'1'),array("OriginalEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->OriginalEmail->updateAll(array("OriginalEmail.show_home"=>'1'),array("OriginalEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->OriginalEmail->updateAll(array("OriginalEmail.show_home"=>'0'),array("OriginalEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->OriginalEmail->deleteAll(array('OriginalEmail.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['OriginalEmail']['title']) && $this->data['OriginalEmail']['title']!='') $title = $this->data['OriginalEmail']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['OriginalEmail']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['OriginalEmail.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('OriginalEmail.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('original_emails', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add OriginalEmail'));
		if ($this->request->is('post')) {
			$this->OriginalEmail->create();	
			$pre_title_check = $this->OriginalEmail->find("count",array("conditions"=>array("OriginalEmail.title"=>$this->request->data['OriginalEmail']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['OriginalEmail']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->OriginalEmail->save($this->request->data['OriginalEmail'])){
					$this->Session->setFlash(__('Original Email has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Original Email could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Original Email title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit OriginalEmail'));
		$this->OriginalEmail->id = $id;
		$selected = "";
		
		$driver_detail = $this->OriginalEmail->find("first",array("conditions"=>array("OriginalEmail.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->OriginalEmail->exists()) {
			throw new NotFoundException(__('Invalid original_email'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['OriginalEmail']['id']=$id;		
			$pre_title_check = $this->OriginalEmail->find("count",array("conditions"=>array("OriginalEmail.title"=>$this->request->data['OriginalEmail']['title'],"OriginalEmail.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->OriginalEmail->saveAll($this->request->data['OriginalEmail'])) {
					$this->Session->setFlash(__('Original Email has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Original Email could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Original Email title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->OriginalEmail->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->OriginalEmail->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->OriginalEmail->id = $id;
		if (!$this->OriginalEmail->exists()) {
			throw new NotFoundException(__('Invalid Original Email'));
		}
		else
		{
			if ($this->OriginalEmail->delete()) {
				$this->Session->setFlash(__('Original Email has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Original Email could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
