<?php
App::uses('AppController', 'Controller');
class DealStatusesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealStatus','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealStatus.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealStatus->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->DealStatus->updateAll(array("DealStatus.status"=>'0'),array("DealStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->DealStatus->updateAll(array("DealStatus.status"=>'1'),array("DealStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->DealStatus->updateAll(array("DealStatus.show_home"=>'1'),array("DealStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->DealStatus->updateAll(array("DealStatus.show_home"=>'0'),array("DealStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->DealStatus->deleteAll(array('DealStatus.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['DealStatus']['title']) && $this->data['DealStatus']['title']!='') $title = $this->data['DealStatus']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['DealStatus']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['DealStatus.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealStatus.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deal_statuses', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add DealStatus'));
		if ($this->request->is('post')) {
			$this->DealStatus->create();	
			$pre_title_check = $this->DealStatus->find("count",array("conditions"=>array("DealStatus.title"=>$this->request->data['DealStatus']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['DealStatus']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->DealStatus->save($this->request->data['DealStatus'])){
					$this->Session->setFlash(__('Deal Status has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Deal Status could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Deal Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit DealStatus'));
		$this->DealStatus->id = $id;
		$selected = "";
		
		$driver_detail = $this->DealStatus->find("first",array("conditions"=>array("DealStatus.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->DealStatus->exists()) {
			throw new NotFoundException(__('Invalid deal_status'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealStatus']['id']=$id;		
			$pre_title_check = $this->DealStatus->find("count",array("conditions"=>array("DealStatus.title"=>$this->request->data['DealStatus']['title'],"DealStatus.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->DealStatus->saveAll($this->request->data['DealStatus'])) {
					$this->Session->setFlash(__('Deal Status has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal Status could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Deal Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->DealStatus->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->DealStatus->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->DealStatus->id = $id;
		if (!$this->DealStatus->exists()) {
			throw new NotFoundException(__('Invalid Deal Status'));
		}
		else
		{
			if ($this->DealStatus->delete()) {
				$this->Session->setFlash(__('Deal Status has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal Status could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
