<?php
App::uses('AppController', 'Controller');
class DealPaymentsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealPayment','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealPayment.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealPayment->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->DealPayment->updateAll(array("DealPayment.status"=>'0'),array("DealPayment.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->DealPayment->updateAll(array("DealPayment.status"=>'1'),array("DealPayment.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->DealPayment->updateAll(array("DealPayment.show_home"=>'1'),array("DealPayment.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->DealPayment->updateAll(array("DealPayment.show_home"=>'0'),array("DealPayment.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->DealPayment->deleteAll(array('DealPayment.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['DealPayment']['title']) && $this->data['DealPayment']['title']!='') $title = $this->data['DealPayment']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['DealPayment']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['DealPayment.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealPayment.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deal_payments', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add DealPayment'));
		if ($this->request->is('post')) {
			$this->DealPayment->create();	
			$pre_title_check = $this->DealPayment->find("count",array("conditions"=>array("DealPayment.title"=>$this->request->data['DealPayment']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['DealPayment']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->DealPayment->save($this->request->data['DealPayment'])){
					$this->Session->setFlash(__('Deal Payment has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Deal Payment could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Deal Payment title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit DealPayment'));
		$this->DealPayment->id = $id;
		$selected = "";
		
		$driver_detail = $this->DealPayment->find("first",array("conditions"=>array("DealPayment.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->DealPayment->exists()) {
			throw new NotFoundException(__('Invalid deal_payment'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealPayment']['id']=$id;		
			$pre_title_check = $this->DealPayment->find("count",array("conditions"=>array("DealPayment.title"=>$this->request->data['DealPayment']['title'],"DealPayment.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->DealPayment->saveAll($this->request->data['DealPayment'])) {
					$this->Session->setFlash(__('Deal Payment has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal Payment could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Deal Payment title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->DealPayment->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->DealPayment->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->DealPayment->id = $id;
		if (!$this->DealPayment->exists()) {
			throw new NotFoundException(__('Invalid Deal Payment'));
		}
		else
		{
			if ($this->DealPayment->delete()) {
				$this->Session->setFlash(__('Deal Payment has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal Payment could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
