<?php
App::uses('AppController', 'Controller');
class ThemeSitesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ThemeSite','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ThemeSite.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ThemeSite->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->ThemeSite->updateAll(array("ThemeSite.status"=>'0'),array("ThemeSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->ThemeSite->updateAll(array("ThemeSite.status"=>'1'),array("ThemeSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->ThemeSite->updateAll(array("ThemeSite.show_home"=>'1'),array("ThemeSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->ThemeSite->updateAll(array("ThemeSite.show_home"=>'0'),array("ThemeSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->ThemeSite->deleteAll(array('ThemeSite.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['ThemeSite']['title']) && $this->data['ThemeSite']['title']!='') $title = $this->data['ThemeSite']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['ThemeSite']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['ThemeSite.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ThemeSite.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('theme_sites', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add ThemeSite'));
		if ($this->request->is('post')) {
			$this->ThemeSite->create();	
			$pre_title_check = $this->ThemeSite->find("count",array("conditions"=>array("ThemeSite.title"=>$this->request->data['ThemeSite']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['ThemeSite']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->ThemeSite->save($this->request->data['ThemeSite'])){
					$this->Session->setFlash(__('Theme Site has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Theme Site could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Theme Site title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit ThemeSite'));
		$this->ThemeSite->id = $id;
		$selected = "";
		
		$driver_detail = $this->ThemeSite->find("first",array("conditions"=>array("ThemeSite.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->ThemeSite->exists()) {
			throw new NotFoundException(__('Invalid theme_site'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['ThemeSite']['id']=$id;		
			$pre_title_check = $this->ThemeSite->find("count",array("conditions"=>array("ThemeSite.title"=>$this->request->data['ThemeSite']['title'],"ThemeSite.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->ThemeSite->saveAll($this->request->data['ThemeSite'])) {
					$this->Session->setFlash(__('Theme Site has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Theme Site could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Theme Site title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->ThemeSite->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->ThemeSite->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ThemeSite->id = $id;
		if (!$this->ThemeSite->exists()) {
			throw new NotFoundException(__('Invalid Theme Site'));
		}
		else
		{
			if ($this->ThemeSite->delete()) {
				$this->Session->setFlash(__('Theme Site has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Theme Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
