<?php
App::uses('AppController', 'Controller');
class ProviderPaymentStatusesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ProviderPaymentStatus','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ProviderPaymentStatus.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->ProviderPaymentStatus->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->ProviderPaymentStatus->updateAll(array("ProviderPaymentStatus.status"=>'0'),array("ProviderPaymentStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->ProviderPaymentStatus->updateAll(array("ProviderPaymentStatus.status"=>'1'),array("ProviderPaymentStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->ProviderPaymentStatus->updateAll(array("ProviderPaymentStatus.show_home"=>'1'),array("ProviderPaymentStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->ProviderPaymentStatus->updateAll(array("ProviderPaymentStatus.show_home"=>'0'),array("ProviderPaymentStatus.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->ProviderPaymentStatus->deleteAll(array('ProviderPaymentStatus.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['ProviderPaymentStatus']['title']) && $this->data['ProviderPaymentStatus']['title']!='') $title = $this->data['ProviderPaymentStatus']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['ProviderPaymentStatus']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['ProviderPaymentStatus.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ProviderPaymentStatus.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('provider_payment_statuses', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add ProviderPaymentStatus'));
		if ($this->request->is('post')) {
			$this->ProviderPaymentStatus->create();	
			$pre_title_check = $this->ProviderPaymentStatus->find("count",array("conditions"=>array("ProviderPaymentStatus.title"=>$this->request->data['ProviderPaymentStatus']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['ProviderPaymentStatus']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->ProviderPaymentStatus->save($this->request->data['ProviderPaymentStatus'])){
					$this->Session->setFlash(__('Provider Payment Status has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Provider Payment Status could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Provider Payment Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit ProviderPaymentStatus'));
		$this->ProviderPaymentStatus->id = $id;
		$selected = "";
		
		$driver_detail = $this->ProviderPaymentStatus->find("first",array("conditions"=>array("ProviderPaymentStatus.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->ProviderPaymentStatus->exists()) {
			throw new NotFoundException(__('Invalid provider payment status'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['ProviderPaymentStatus']['id']=$id;		
			$pre_title_check = $this->ProviderPaymentStatus->find("count",array("conditions"=>array("ProviderPaymentStatus.title"=>$this->request->data['ProviderPaymentStatus']['title'],"ProviderPaymentStatus.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->ProviderPaymentStatus->saveAll($this->request->data['ProviderPaymentStatus'])) {
					$this->Session->setFlash(__('Provider Payment Status has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Provider Payment Status could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Provider Payment Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->ProviderPaymentStatus->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->ProviderPaymentStatus->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ProviderPaymentStatus->id = $id;
		if (!$this->ProviderPaymentStatus->exists()) {
			throw new NotFoundException(__('Invalid Provider Payment Status'));
		}
		else
		{
			if ($this->ProviderPaymentStatus->delete()) {
				$this->Session->setFlash(__('Provider Payment Status has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Provider Payment Status could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
