<?php
App::uses('AppController', 'Controller');
class EmployeeEmailsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('EmployeeEmail','EmailTemplate','ApplicationSetting','FamilyMember','Site'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'EmployeeEmail.id' => 'desc'
        )
    );
	public function beforeFilter() {
        parent::beforeFilter();
	}	
	public function admin_index($id = null) {
		$this->checkNormal();
		$this->set('title_for_layout', __('Admin'));
		$this->EmployeeEmail->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='DeActive')
				$this->EmployeeEmail->updateAll(array("EmployeeEmail.status"=>'0'),array("EmployeeEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				$this->EmployeeEmail->updateAll(array("EmployeeEmail.status"=>'1'),array("EmployeeEmail.id"=>$this->request->data['frmList']['ID']));
				foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$this->add_site_data($userid);
				}
			}
			else if($this->request->data['task_value']=='Delete')
			{
				$this->EmployeeEmail->deleteAll(array('EmployeeEmail.id' => $this->request->data['frmList']['ID']), false);
				$this->Session->setFlash(__('Employee Email has been deleted successfully.'), 'default', array('class' => 'success'));
			}
			else if($this->request->data['task_value']=='selected_operator'  &&  $this->request->data['EmployeeEmail']['operator_id'] !="")
			{
				$this->EmployeeEmail->updateAll(array('EmployeeEmail.user_id' => $this->request->data['EmployeeEmail']['operator_id']),array("EmployeeEmail.id"=>$this->request->data['frmList']['ID']));
				unset($this->request->data['EmployeeEmail']['operator_id']);
				$this->Session->setFlash(__('Selected Employee Email has been assigned to operator.'), 'default', array('class' => 'success'));
			}
			else if($this->request->data['task_value']=='all_operator'  &&  $this->request->data['EmployeeEmail']['operator_id'] !="")
			{
				$condition_operator=array("1"=>"1");
				if(isset($this->data['EmployeeEmail']['user_id']) && $this->data['EmployeeEmail']['user_id']!='') $condition_operator["user_id"] = $this->request->data['EmployeeEmail']['user_id'];	
		
				if(isset($this->data['EmployeeEmail']['url']) && $this->data['EmployeeEmail']['url']!='') $condition_operator["url LIKE "] = "%".$this->data['EmployeeEmail']['url']."%";	
				
				
				if(isset($this->data['EmployeeEmail']['operator_edit_date_from']) && $this->data['EmployeeEmail']['operator_edit_date_from']!='') 
				{
					$operator_edit_date_from=$this->data['EmployeeEmail']['operator_edit_date_from'];
					$date_employee_from_temp=$operator_edit_date_from.' 00:00:00';
					if(!empty($operator_edit_time_from))
					{
						$operator_edit_time_from_temp=$this->get_employee_time($operator_edit_time_from);
						$date_employee_from_temp=$operator_edit_date_from.' '.$operator_edit_time_from_temp;
					}
					$condition_operator['EmployeeEmail.operator_edit_date_time >='] = $date_employee_from_temp;
				}
					
				//echo '<pre>';print_r($this->data['EmployeeEmail']);
				if(isset($this->data['EmployeeEmail']['operator_edit_date_to']) && $this->data['EmployeeEmail']['operator_edit_date_to']!='')
				{
					$operator_edit_date_to=$this->data['EmployeeEmail']['operator_edit_date_to'];
					$date_employee_to_temp=$operator_edit_date_to.' 23:59:59';
					if(!empty($operator_edit_time_to))
					{
						$operator_edit_time_to_temp=$this->get_employee_time($operator_edit_time_to);
						$date_employee_to_temp=$operator_edit_date_to.' '.$operator_edit_time_to_temp;
					}
					$conditions['EmployeeEmail.operator_edit_date_time <='] = $date_employee_to_temp;
					$pagingArgs['date_employee_to'] = $date_employee_to;
				
				}
				
				if(isset($this->data['EmployeeEmail']['date_employee_from']) && $this->data['EmployeeEmail']['date_employee_from']!='') $condition_operator["date_employee_from  >="] = $this->data['EmployeeEmail']['date_employee_from'].' 00:00:00';	
				
				if(isset($this->data['EmployeeEmail']['date_employee_to']) && $this->data['EmployeeEmail']['date_employee_to']!='') $condition_operator["date_employee_to <="] = $this->request->data['EmployeeEmail']['date_employee_to'].' 23:59:59';
				
				if(isset($this->data['EmployeeEmail']['employee_error_id']) && $this->data['EmployeeEmail']['employee_error_id']!='') $condition_operator["employee_error_id"] = $this->data['EmployeeEmail']['employee_error_id'];	
				
				if(isset($this->data['EmployeeEmail']['error_type_id']) && $this->data['EmployeeEmail']['error_type_id']!='') $condition_operator["error_type_id"] = $this->data['EmployeeEmail']['error_type_id'];
				
				if(isset($this->data['EmployeeEmail']['status_employee_id']) && $this->data['EmployeeEmail']['status_employee_id']!='') $condition_operator["status_employee_id"] = $this->data['EmployeeEmail']['status_employee_id'];	
				
				if(isset($this->data['EmployeeEmail']['operator_edit_status']) && $this->data['EmployeeEmail']['operator_edit_status']!='') $condition_operator["operator_edit_status"] = $this->data['EmployeeEmail']['operator_edit_status'];	
				
				if(isset($this->data['EmployeeEmail']['tld']) && $this->data['EmployeeEmail']['tld']!='') $condition_operator["EmployeeEmail.url like "] = '%'.$this->data['EmployeeEmail']['tld'];
				
				if(isset($this->data['EmployeeEmail']['language_id']) && $this->data['EmployeeEmail']['language_id']!='') $condition_operator["EmployeeEmail.language_id"] = $this->data['EmployeeEmail']['language_id'];
				
				$this->EmployeeEmail->updateAll(array('EmployeeEmail.user_id' => $this->request->data['EmployeeEmail']['operator_id']),$condition_operator);
				unset($this->request->data['EmployeeEmail']['operator_id']);
				$this->Session->setFlash(__('Search Result Employee Email has been assigned to operator.'), 'default', array('class' => 'success'));
			}
		}
		
		if(isset($this->data['EmployeeEmail']['user_id']) && $this->data['EmployeeEmail']['user_id']!='') $user_id = $this->request->data['EmployeeEmail']['user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->request->data['EmployeeEmail']['user_id']=$this->params['named']['user_id'];	
		
		if(isset($this->data['EmployeeEmail']['operator_edit_date_from']) && $this->data['EmployeeEmail']['operator_edit_date_from']!='') $operator_edit_date_from = $this->data['EmployeeEmail']['operator_edit_date_from'];	
		else if(isset($this->params['named']['operator_edit_date_from']) && $this->params['named']['operator_edit_date_from']!='') $operator_edit_date_from =$this->request->data['EmployeeEmail']['operator_edit_date_from']=$this->params['named']['operator_edit_date_from'];
		//echo '<pre>';print_r($this->data['EmployeeEmail']);
		if(isset($this->data['EmployeeEmail']['operator_edit_time_from']) && $this->data['EmployeeEmail']['operator_edit_time_from']!='') $operator_edit_time_from = $this->data['EmployeeEmail']['operator_edit_time_from'];	
		else if(isset($this->params['named']['operator_edit_time_from']) && $this->params['named']['operator_edit_time_from']!='') $operator_edit_time_from =$this->request->data['EmployeeEmail']['operator_edit_time_from']=$this->params['named']['operator_edit_time_from'];
		
		if(isset($this->data['EmployeeEmail']['operator_edit_date_to']) && $this->data['EmployeeEmail']['operator_edit_date_to']!='') $operator_edit_date_to = $this->request->data['EmployeeEmail']['operator_edit_date_to'];	
		else if(isset($this->params['named']['operator_edit_date_to']) && $this->params['named']['operator_edit_date_to']!='') $operator_edit_date_to = $this->request->data['EmployeeEmail']['operator_edit_date_to']=$this->params['named']['operator_edit_date_to'];
		
		if(isset($this->data['EmployeeEmail']['operator_edit_time_to']) && $this->data['EmployeeEmail']['operator_edit_time_to']!='') $operator_edit_time_to = $this->request->data['EmployeeEmail']['operator_edit_time_to'];	
		else if(isset($this->params['named']['operator_edit_time_to']) && $this->params['named']['operator_edit_time_to']!='') $operator_edit_time_to = $this->request->data['EmployeeEmail']['operator_edit_time_to']=$this->params['named']['operator_edit_time_to'];
		
		if(isset($this->data['EmployeeEmail']['date_employee_from']) && $this->data['EmployeeEmail']['date_employee_from']!='') $date_employee_from = $this->data['EmployeeEmail']['date_employee_from'];	
		else if(isset($this->params['named']['date_employee_from']) && $this->params['named']['date_employee_from']!='') $date_employee_from =$this->request->data['EmployeeEmail']['date_employee_from']=$this->params['named']['date_employee_from'];
		
		if(isset($this->data['EmployeeEmail']['date_employee_to']) && $this->data['EmployeeEmail']['date_employee_to']!='') $date_employee_to = $this->request->data['EmployeeEmail']['date_employee_to'];	
		else if(isset($this->params['named']['date_employee_to']) && $this->params['named']['date_employee_to']!='') $date_employee_to = $this->request->data['EmployeeEmail']['date_employee_to']=$this->params['named']['date_employee_to'];
		
		if(isset($this->data['EmployeeEmail']['employee_error_id']) && $this->data['EmployeeEmail']['employee_error_id']!='') $employee_error_id = $this->data['EmployeeEmail']['employee_error_id'];	
		else if(isset($this->params['named']['employee_error_id']) && $this->params['named']['employee_error_id']!='') $employee_error_id = $this->request->data['EmployeeEmail']['employee_error_id']=$this->params['named']['employee_error_id'];
		
		if(isset($this->data['EmployeeEmail']['error_type_id']) && $this->data['EmployeeEmail']['error_type_id']!='') $error_type_id = $this->data['EmployeeEmail']['error_type_id'];	
		else if(isset($this->params['named']['error_type_id']) && $this->params['named']['error_type_id']!='') $error_type_id = $this->request->data['EmployeeEmail']['error_type_id']=$this->params['named']['error_type_id'];
		
		if(isset($this->data['EmployeeEmail']['url']) && $this->data['EmployeeEmail']['url']!='') $url = $this->data['EmployeeEmail']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['EmployeeEmail']['url']=$this->params['named']['url'];
		
		
		if(isset($this->data['EmployeeEmail']['status_employee_id']) && $this->data['EmployeeEmail']['status_employee_id']!='') $status_employee_id = $this->data['EmployeeEmail']['status_employee_id'];	
		else if(isset($this->params['named']['status_employee_id']) && $this->params['named']['status_employee_id']!='') $status_employee_id = $this->data['EmployeeEmail']['status_employee_id']=$this->params['named']['status_employee_id'];
		
		if(isset($this->data['EmployeeEmail']['operator_edit_status']) && $this->data['EmployeeEmail']['operator_edit_status']!='') $operator_edit_status = $this->data['EmployeeEmail']['operator_edit_status'];	
		else if(isset($this->params['named']['operator_edit_status']) && $this->params['named']['operator_edit_status']!='') $operator_edit_status = $this->data['EmployeeEmail']['operator_edit_status']=$this->params['named']['operator_edit_status'];
		
		if(isset($this->data['EmployeeEmail']['tld']) && $this->data['EmployeeEmail']['tld']!='') $tld = $this->data['EmployeeEmail']['tld'];	
		else if(isset($this->params['named']['tld']) && $this->params['named']['tld']!='') $tld = $this->request->data['EmployeeEmail']['tld']=$this->params['named']['tld'];	
		
		if(isset($this->data['EmployeeEmail']['comment']) && $this->data['EmployeeEmail']['comment']!='') $comment = $this->data['EmployeeEmail']['comment'];	
		else if(isset($this->params['named']['comment']) && $this->params['named']['comment']!='') $comment = $this->request->data['EmployeeEmail']['comment']=$this->params['named']['comment'];	
		
		if(isset($this->data['EmployeeEmail']['comment2']) && $this->data['EmployeeEmail']['comment2']!='') $comment2 = $this->data['EmployeeEmail']['comment2'];	
		else if(isset($this->params['named']['comment2']) && $this->params['named']['comment2']!='') $comment2 = $this->request->data['EmployeeEmail']['comment2']=$this->params['named']['comment2'];	
		
		if(isset($this->data['EmployeeEmail']['language_id']) && $this->data['EmployeeEmail']['language_id']!='') $language_id = $this->data['EmployeeEmail']['language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['EmployeeEmail']['language_id']=$this->params['named']['language_id'];	
		
		if(isset($this->data['EmployeeEmail']['limit']) && $this->data['EmployeeEmail']['limit']!='') $limit = $this->request->data['EmployeeEmail']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['EmployeeEmail']['limit']=$this->params['named']['limit'];
		
		//echo '<pre>';print_r($this->data['EmployeeEmail']);
		$order_arr=array('EmployeeEmail.operator_edit_date_time'=>'DESC');
		$conditions = array(); 
		$pagingArgs = array(); 
		if($this->Session->read('Auth.User.role') =='3')
		{
			$conditions = array("user_id"=>$this->Auth->user('id'));
			$conditions["operator_edit_status <>"] = 1;
			$order_arr=array('EmployeeEmail.id'=>'ASC');
		}
		if(!empty($user_id))
		{
			$conditions['EmployeeEmail.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($url))
		{
			$conditions['EmployeeEmail.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		if(!empty($operator_edit_date_from))
		{
			$date_employee_from_temp=$operator_edit_date_from.' 00:00:00';
			if(!empty($operator_edit_time_from))
			{
				$operator_edit_time_from_temp=$this->get_employee_time($operator_edit_time_from);
				$date_employee_from_temp=$operator_edit_date_from.' '.$operator_edit_time_from_temp;
				$pagingArgs['operator_edit_time_from'] = $operator_edit_time_from;
			}
			$conditions['EmployeeEmail.operator_edit_date_time >='] = $date_employee_from_temp;
			$pagingArgs['operator_edit_date_from'] = $operator_edit_date_from;
		}
		if(!empty($operator_edit_date_to))
		{
			$date_employee_to_temp=$operator_edit_date_to.' 23:59:59';
			if(!empty($operator_edit_time_to))
			{
				$operator_edit_time_to_temp=$this->get_employee_time($operator_edit_time_to);
				$date_employee_to_temp=$operator_edit_date_to.' '.$operator_edit_time_to_temp;
				$pagingArgs['operator_edit_time_to'] = $operator_edit_time_to;
			}
			$conditions['EmployeeEmail.operator_edit_date_time <='] = $date_employee_to_temp;
			$pagingArgs['operator_edit_date_to'] = $operator_edit_date_to;
		}
		if(!empty($date_employee_from))
		{
			$conditions['EmployeeEmail.date_employee >='] = $date_employee_from.' 00:00:00';
			$pagingArgs['date_employee_from'] = $date_employee_from;
		}
		if(!empty($date_employee_to))
		{
			$conditions['EmployeeEmail.date_employee <='] = $date_employee_to.' 23:59:59';
			$pagingArgs['date_employee_from'] = $date_employee_to;
		}
		if(!empty($employee_error_id))
		{
			$conditions['EmployeeEmail.employee_error_id'] = $employee_error_id;
			$pagingArgs['employee_error_id'] = $employee_error_id;
		}
		if(!empty($error_type_id))
		{
			$conditions['EmployeeEmail.error_type_id'] = $error_type_id;
			$pagingArgs['error_type_id'] = $error_type_id;
		}
		if(!empty($status_employee_id))
		{
			$conditions['EmployeeEmail.status_employee_id'] = $status_employee_id;
			$pagingArgs['status_employee_id'] = $status_employee_id;
		}	
		if(!empty($operator_edit_status))
		{
			$conditions['EmployeeEmail.operator_edit_status'] = $operator_edit_status;
			$pagingArgs['operator_edit_status'] = $operator_edit_status;
		}	
		if(!empty($tld))
		{
			$conditions['EmployeeEmail.url like '] = '%'.$tld;
			$pagingArgs['tld'] = $tld;
		}
		if(!empty($comment))
		{
			$conditions['EmployeeEmail.comment <>'] = "";
			$pagingArgs['comment'] = $comment;
		}
		if(!empty($comment2))
		{
			$conditions['EmployeeEmail.comment2 <>'] = "";
			$pagingArgs['comment2'] = $comment2;
		}
		if(!empty($language_id))
		{
			$conditions['EmployeeEmail.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
	 	
		//echo '<pre>';print_r($conditions);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>$order_arr,
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('employee_emails', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "EmployeeEmail";
		if($id != null){
		$this->EmployeeEmail->id = $id;
		if (!$this->EmployeeEmail->exists()) {
			throw new NotFoundException(__('Invalid EmployeeEmail'));
		}
		}
		
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set('title_for_layout', __('Add EmployeeEmail'));
		if ($this->request->is('post')) {
			$this->EmployeeEmail->create();
			$this->request->data['EmployeeEmail']['user_id']=$user_id;
			$this->request->data['EmployeeEmail']['date_time']			=	date("Y-m-d H:i:s");
			if ($res=$this->EmployeeEmail->save($this->request->data['EmployeeEmail'])){	
				$site_id=$res['EmployeeEmail']['id'];
				$this->Session->setFlash(__('Employee Email has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'add'));
			} else {
				$this->Session->setFlash(__('Employee Email could not be added.'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'add'));
			}
		}
	}
	public function admin_edit($id = null) {
		$this->checkNormal();
		$this->set('title_for_layout', __('Edit EmployeeEmail'));
		$this->EmployeeEmail->id = $id;
		$selected = "";
		
		$driver_detail = $this->EmployeeEmail->find("first",array("conditions"=>array("EmployeeEmail.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if($driver_detail['EmployeeEmail']['operator_edit_status']=='1' && $this->Session->read('Auth.User.role') =='3')
		{
			$this->Session->setFlash(__('Employee Email already submitted.'), 'default', array('class' => 'error'));
			$this->redirect(array('action' => 'index'));
		}
		if (!$this->EmployeeEmail->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			
			$user_role = $this->Auth->user('role');	
			if($user_role=='3' || $user_role=='2')
			{
				if(empty($driver_detail['EmployeeEmail']['operator_edit_date_time']))
					$this->request->data['EmployeeEmail']['operator_edit_date_time']	=	date("Y-m-d H:i:s");
				$this->request->data['EmployeeEmail']['operator_edit_status']		=	1;
			}
			$this->request->data['EmployeeEmail']['id']=$id;
			if ($res=$this->EmployeeEmail->saveAll($this->request->data['EmployeeEmail'])) {
				$site_id=$id;	
				$this->Session->setFlash(__('Employee Email has been added successfully.'), 'default', array('class' => 'success'));
				if($this->Session->read('Auth.User.role') =='3')
					$this->redirect(array('action' => 'index'));
				else
					$this->redirect(array('action' => 'edit',$id));
			} 
			$this->request->data = $this->EmployeeEmail->read(null, $id);
			$this->redirect(array('action' => 'edit',$id));
		} 
		$pre_data= $this->EmployeeEmail->find("first",array("conditions"=>array("EmployeeEmail.id"=>$id)));
		$this->request->data = $pre_data;
	}
	public function admin_view($id = null) {
		$this->checkNormal();
		$this->set('title_for_layout', __('Edit Employee Email'));
		$this->EmployeeEmail->id = $id;
		$selected = "";
		
		$driver_detail = $this->EmployeeEmail->find("first",array("conditions"=>array("EmployeeEmail.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->EmployeeEmail->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		
		$pre_data= $this->EmployeeEmail->find("first",array("conditions"=>array("EmployeeEmail.id"=>$id)));
		$this->set('employee_emails', $pre_data);
	}
	public function admin_delete($id = null) {
		$this->checkSubAdmin();
		$this->EmployeeEmail->id = $id;
		if (!$this->EmployeeEmail->exists()) {
			throw new NotFoundException(__('Invalid Employee Email'));
		}
		else
		{
			if ($this->EmployeeEmail->delete()) {
				$this->Session->setFlash(__('Employee Email has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Employee Email could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
	public function admin_upload_csv()
	{
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set('title_for_layout', __('Add Employee Email'));
		if ($this->request->is('post')) {
			$this->EmployeeEmail->create();
			$this->request->data['EmployeeEmail']['user_id']=$user_id;
			$this->request->data['EmployeeEmail']['date_time']			=	date("Y-m-d H:i:s");			
			if (($handle = fopen($this->request->data['EmployeeEmail']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				 if($count==1)
				 {
					 $count++;
				 	continue;
				 }
				$arr['id']='';
				$arr['url']=trim($data[0]);
				$arr['language_id']=$this->get_language_id(trim($data[1]));
				$arr['contact_way_id']=$this->get_contact_way_id(trim($data[2]));
				$arr['contact_email_ids']=trim($data[3]);
				$arr['contact_page_url']=trim($data[4]);
				$arr['date_employee']=trim($data[5]);
				$arr['original_email_id']=$this->get_original_email_id(trim($data[6]));	
				$arr['employee_id']=$this->get_employee_id(trim($data[7]));
				$arr['employee_error_id']=$this->get_employee_error_id(trim($data[8]));
				$arr['error_type_id']=$this->get_error_type_id(trim($data[9]));
				$arr['status_employee_id']=$this->get_status_employee_id(trim($data[10]));
				$arr['comment']=$this->get_status_employee_id(trim($data[11]));
				$arr['comment2']=$this->get_status_employee_id(trim($data[12]));
				$arr['date_time']=date("Y-m-d H:i:s");
				$res=$this->EmployeeEmail->save($arr);
				$count++;
			  }
			  fclose($handle);
			}
			$this->Session->setFlash(__('Employee Email has been added successfully.'), 'default', array('class' => 'success'));
			$this->redirect(array('action' => 'index'));
		}
	}
	public function admin_download_csv()
	{
		$this->checkSubAdmin();
		Configure::write('debug',0);
		$this->autoRender = false;
		$this->EmployeeEmail->recursive = 0;
		
		if(isset($this->data['download']['search_user_id']) && $this->data['download']['search_user_id']!='') $user_id = $this->data['download']['search_user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->data['EmployeeEmail']['user_id']=$this->params['named']['user_id'];	
		
		
		if(isset($this->data['download']['search_operator_edit_date_from']) && $this->data['download']['search_operator_edit_date_from']!='') $operator_edit_date_from = $this->data['download']['search_operator_edit_date_from'];
		if(isset($this->data['download']['search_operator_edit_date_to']) && $this->data['download']['search_operator_edit_date_to']!='') $operator_edit_date_to = $this->data['download']['search_operator_edit_date_to'];
		
		if(isset($this->data['download']['search_operator_edit_time_from']) && $this->data['download']['search_operator_edit_time_from']!='') $operator_edit_time_from = $this->data['download']['search_operator_edit_time_from'];
		if(isset($this->data['download']['search_operator_edit_time_to']) && $this->data['download']['search_operator_edit_time_to']!='') $operator_edit_time_to = $this->data['download']['search_operator_edit_time_to'];
		
		
		if(isset($this->data['download']['search_date_employee_from']) && $this->data['download']['search_date_employee_from']!='') $date_employee_from = $this->data['download']['search_date_employee_from'];	
		else if(isset($this->params['named']['date_employee_from']) && $this->params['named']['date_employee_from']!='') $date_employee_from =$this->data['EmployeeEmail']['date_employee_from']=$this->params['named']['date_employee_from'];
		
		
		if(isset($this->data['download']['search_date_employee_to']) && $this->data['download']['search_date_employee_to']!='') $date_employee_to = $this->data['download']['search_date_employee_to'];	
		else if(isset($this->params['named']['date_employee_to']) && $this->params['named']['date_employee_to']!='') $date_employee_to = $this->data['EmployeeEmail']['date_employee_to']=$this->params['named']['date_employee_to'];
		
		if(isset($this->data['download']['search_employee_error_id']) && $this->data['download']['search_employee_error_id']!='') $employee_error_id = $this->data['download']['search_employee_error_id'];	
		else if(isset($this->params['named']['employee_error_id']) && $this->params['named']['employee_error_id']!='') $employee_error_id = $this->data['EmployeeEmail']['employee_error_id']=$this->params['named']['employee_error_id'];
		
		if(isset($this->data['download']['search_error_type_id']) && $this->data['download']['search_error_type_id']!='') $error_type_id = $this->data['download']['search_error_type_id'];	
		else if(isset($this->params['named']['error_type_id']) && $this->params['named']['error_type_id']!='') $error_type_id = $this->data['EmployeeEmail']['error_type_id']=$this->params['named']['error_type_id'];
		
		if(isset($this->data['download']['search_url']) && $this->data['download']['search_url']!='') $url = $this->data['download']['search_url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->data['EmployeeEmail']['url']=$this->params['named']['url'];
		
		
		if(isset($this->data['download']['search_status_employee_id']) && $this->data['download']['search_status_employee_id']!='') $status_employee_id = $this->data['download']['search_status_employee_id'];	
		else if(isset($this->params['named']['status_employee_id']) && $this->params['named']['status_employee_id']!='') $status_employee_id = $this->data['EmployeeEmail']['status_employee_id']=$this->params['named']['status_employee_id'];
		
		if(isset($this->data['download']['search_operator_edit_status']) && $this->data['download']['search_operator_edit_status']!='') $search_operator_edit_status = $this->data['download']['search_operator_edit_status'];	
		else if(isset($this->params['named']['search_operator_edit_status']) && $this->params['named']['search_operator_edit_status']!='') $search_operator_edit_status = $this->data['download']['search_operator_edit_status']=$this->params['named']['search_operator_edit_status'];
		
		if(isset($this->data['download']['search_tld']) && $this->data['download']['search_tld']!='') $tld = $this->data['download']['search_tld'];	
		else if(isset($this->params['named']['search_tld']) && $this->params['named']['search_tld']!='') $tld = $this->request->data['download']['search_tld']=$this->params['named']['search_tld'];
		
		if(isset($this->data['download']['search_comment']) && $this->data['download']['search_comment']!='') $comment = $this->data['download']['search_comment'];	
		
		if(isset($this->data['download']['search_language_id']) && $this->data['download']['search_language_id']!='') $language_id = $this->data['download']['search_language_id'];	
		
		if(isset($this->data['download']['search_comment2']) && $this->data['download']['search_comment2']!='') $comment2 = $this->data['download']['search_comment2'];	
		
		if(isset($this->data['download']['search_limit']) && $this->data['download']['search_limit']!='') $limit = $this->data['download']['search_limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->data['download']['limit']=$this->params['named']['limit'];
		
		//echo '<pre>';print_r($this->data['download']);die;
		
		$conditions = array(); 
		$pagingArgs = array(); 
		if(!empty($user_id))
		{
			$conditions['EmployeeEmail.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($url))
		{
			$conditions['EmployeeEmail.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		if(!empty($operator_edit_date_from))
		{
			$date_employee_from_temp=$operator_edit_date_from.' 00:00:00';
			if(!empty($operator_edit_time_from))
			{
				$operator_edit_time_from_temp=$this->get_employee_time($operator_edit_time_from);
				$date_employee_from_temp=$operator_edit_date_from.' '.$operator_edit_time_from_temp;
				$pagingArgs['operator_edit_time_from'] = $operator_edit_time_from;
			}
			$conditions['EmployeeEmail.operator_edit_date_time >='] = $date_employee_from_temp;
			$pagingArgs['operator_edit_date_from'] = $operator_edit_date_from;
		}
		if(!empty($operator_edit_date_to))
		{
			$date_employee_to_temp=$operator_edit_date_to.' 23:59:59';
			if(!empty($operator_edit_time_to))
			{
				$operator_edit_time_to_temp=$this->get_employee_time($operator_edit_time_to);
				$date_employee_to_temp=$operator_edit_date_to.' '.$operator_edit_time_to_temp;
				$pagingArgs['operator_edit_time_to'] = $operator_edit_time_to;
			}
			$conditions['EmployeeEmail.operator_edit_date_time <='] = $date_employee_to_temp;
			$pagingArgs['operator_edit_date_to'] = $operator_edit_date_to;
		}
		if(!empty($date_employee_from))
		{
			$conditions['EmployeeEmail.date_employee >='] = $date_employee_from;
			$pagingArgs['date_employee_from'] = $date_employee_from;
		}
		if(!empty($date_employee_to))
		{
			$conditions['EmployeeEmail.date_employee <='] = $date_employee_to;
			$pagingArgs['date_employee_to'] = $date_employee_to;
		}
		if(!empty($employee_error_id))
		{
			$conditions['EmployeeEmail.employee_error_id'] = $employee_error_id;
			$pagingArgs['employee_error_id'] = $employee_error_id;
		}
		if(!empty($error_type_id))
		{
			$conditions['EmployeeEmail.error_type_id'] = $error_type_id;
			$pagingArgs['error_type_id'] = $error_type_id;
		}
		if(!empty($status_employee_id))
		{
			$conditions['EmployeeEmail.status_employee_id'] = $status_employee_id;
			$pagingArgs['status_employee_id'] = $status_employee_id;
		}		
		if(!empty($search_operator_edit_status))
		{
			$conditions['EmployeeEmail.operator_edit_status'] = $search_operator_edit_status;
		}
		if(!empty($tld))
		{
			$conditions['EmployeeEmail.url like '] = '%'.$tld;
			$pagingArgs['tld'] = $tld;
		}
		if(!empty($comment))
		{
			$conditions['EmployeeEmail.comment <>'] = "";
			$pagingArgs['comment'] = $comment;
		}
		if(!empty($comment2) && $comment2 !="")
		{
			$conditions['EmployeeEmail.comment2 <>'] = "";
			$pagingArgs['comment2'] = $comment2;
		}
		if(!empty($language_id))
		{
			$conditions['EmployeeEmail.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		//echo '<pre>';print_r($conditions);die;	
		$rows = $this->EmployeeEmail->find("all",array('order'=>array('EmployeeEmail.id'=>'DESC'),'conditions'=>$conditions));
		
		$namedate=__("Employee-Email")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Employee-Email");
		$sep = ", ";
		$array_key=array(__("URL"),__("Language"),__("Contact way"),__("Contact email ids "),__("Contact page url"),__("Date"),__("Original Email Id"),__("Operator Name"),__("Error"),__("Error Type"),__("Status"),__("Comment"),__("Comment 2"),__("Date-time"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($rows as $employee_emails)
		{
			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['url'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_language($employee_emails['EmployeeEmail']['language_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_contact_way($employee_emails['EmployeeEmail']['contact_way_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['contact_email_ids'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['contact_page_url'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['date_employee'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_original_email($employee_emails['EmployeeEmail']['original_email_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_operator($employee_emails['EmployeeEmail']['user_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_error($employee_emails['EmployeeEmail']['employee_error_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_error_type($employee_emails['EmployeeEmail']['error_type_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$this->get_status_employee($employee_emails['EmployeeEmail']['status_employee_id']))).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['comment'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['comment2'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$employee_emails['EmployeeEmail']['date_time'])).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
		}
		exit;
	}
	public function admin_import_for_operator()
	{
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set('title_for_layout', __('Import Employee Email'));
		if ($this->request->is('post')) {		
			$existing_url=array();
			$existing_url_list='';
			if (($handle = fopen($this->request->data['EmployeeEmail']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=0;
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				if($count==0)
				{
					$count++;
					continue;
				}
				$siteurl=trim($data[0]);
				$siteurl=trim($siteurl,'/');
				$siteurl=str_replace('http://','',$siteurl);
				$siteurl=str_replace('www.','',$siteurl);
				 // check already added or not
				$count_site=$this->Site->find("count",array("conditions"=>array("Site.url like "=>"%".$siteurl."%")));
				$count_employee=$this->EmployeeEmail->find("count",array("conditions"=>array("EmployeeEmail.url like "=>"%".$siteurl."%")));
				if($count_site ==0 && $count_employee==0)
				{
					$arr['id']='';
					$arr['operator_edit_status']=2;
					$arr['date_employee']=date("Y-m-d");
					$arr['user_id']=$this->request->data['EmployeeEmail']['user_id'];
					$arr['url']=trim($data[0]);
					$arr['full_url']=trim($data[1]);
					$arr['employee_comment']=trim($data[2]);
					$res=$this->EmployeeEmail->save($arr);
					$count++;
				}
				else
				{
					$existing_url[]=trim($data[0]);
				}
			  }
			  fclose($handle);
			}
			$this->Session->setFlash(__(($count-1).' Employee Email have been imported.'), 'default', array('class' => 'success'));
			if(empty($existing_url))
				$this->redirect(array('action' => 'index'));
			else
			{
				$existing_url_list=implode("<br>",$existing_url);
			}
			$this->set("existing_url_list",$existing_url_list);
		}
	}
}
