<?php
App::uses('AppController', 'Controller');
class DealTypesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealType','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealType.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealType->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->DealType->updateAll(array("DealType.status"=>'0'),array("DealType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->DealType->updateAll(array("DealType.status"=>'1'),array("DealType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->DealType->updateAll(array("DealType.show_home"=>'1'),array("DealType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->DealType->updateAll(array("DealType.show_home"=>'0'),array("DealType.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->DealType->deleteAll(array('DealType.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['DealType']['title']) && $this->data['DealType']['title']!='') $title = $this->data['DealType']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['DealType']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['DealType.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealType.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deal_types', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add DealType'));
		if ($this->request->is('post')) {
			$this->DealType->create();	
			$pre_title_check = $this->DealType->find("count",array("conditions"=>array("DealType.title"=>$this->request->data['DealType']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['DealType']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->DealType->save($this->request->data['DealType'])){
					$this->Session->setFlash(__('Deal Type has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Deal Type could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Deal Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit DealType'));
		$this->DealType->id = $id;
		$selected = "";
		
		$driver_detail = $this->DealType->find("first",array("conditions"=>array("DealType.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->DealType->exists()) {
			throw new NotFoundException(__('Invalid deal_type'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealType']['id']=$id;		
			$pre_title_check = $this->DealType->find("count",array("conditions"=>array("DealType.title"=>$this->request->data['DealType']['title'],"DealType.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->DealType->saveAll($this->request->data['DealType'])) {
					$this->Session->setFlash(__('Deal Type has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal Type could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Deal Type title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->DealType->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->DealType->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->DealType->id = $id;
		if (!$this->DealType->exists()) {
			throw new NotFoundException(__('Invalid Deal Type'));
		}
		else
		{
			if ($this->DealType->delete()) {
				$this->Session->setFlash(__('Deal Type has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal Type could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
