<?php
class CakeErrorController extends AppController {
/**
 * Controller name
 *
 * @var string
 */
	public $name = 'CakeError';
/**
 * Uses Property
 *
 * @var array
 */
	public $uses = array();
/**
 * __construct
 *
 * @param CakeRequest $request
 * @param CakeResponse $response
 */
	public function __construct($request = null, $response = null) {
		parent::__construct($request, $response);
		if (count(Router::extensions())) {
			$this->components[] = 'RequestHandler';
		}
		$this->constructClasses();
		if ($this->Components->enabled('Auth')) {
			$this->Components->disable('Auth');
		}
		if ($this->Components->enabled('Security')) {
			$this->Components->disable('Security');
		}
		$this->startupProcess();
		$this->_set(array('cacheAction' => false, 'viewPath' => 'Errors'));
	}
/**
 * Escapes the viewVars.
 *
 * @return void
 */
	public function beforeRender() {
		
		parent::beforeRender();
		foreach ($this->viewVars as $key => $value) {
			if (!is_object($value)) {
				$this->viewVars[$key] = h($value);
			}
		}
	}
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
    public function beforeFilter() {
        parent::beforeFilter();
        $this->Auth->allow('error404');
        $this->Auth->allow('missing_controller');
        $this->Auth->allow('error400');
    }
}
?>