<?php
App::uses('AppController', 'Controller');
class AcceptGamblingsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('AcceptGambling','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'AcceptGambling.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->AcceptGambling->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->AcceptGambling->updateAll(array("AcceptGambling.status"=>'0'),array("AcceptGambling.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->AcceptGambling->updateAll(array("AcceptGambling.status"=>'1'),array("AcceptGambling.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->AcceptGambling->updateAll(array("AcceptGambling.show_home"=>'1'),array("AcceptGambling.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->AcceptGambling->updateAll(array("AcceptGambling.show_home"=>'0'),array("AcceptGambling.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->AcceptGambling->deleteAll(array('AcceptGambling.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['AcceptGambling']['title']) && $this->data['AcceptGambling']['title']!='') $title = $this->data['AcceptGambling']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['AcceptGambling']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['AcceptGambling.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('AcceptGambling.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('accept_gamblings', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add AcceptGambling'));
		if ($this->request->is('post')) {
			$this->AcceptGambling->create();	
			$pre_title_check = $this->AcceptGambling->find("count",array("conditions"=>array("AcceptGambling.title"=>$this->request->data['AcceptGambling']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['AcceptGambling']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->AcceptGambling->save($this->request->data['AcceptGambling'])){
					$this->Session->setFlash(__('Accept Gambling has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Accept Gambling could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Accept Gambling title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit AcceptGambling'));
		$this->AcceptGambling->id = $id;
		$selected = "";
		
		$driver_detail = $this->AcceptGambling->find("first",array("conditions"=>array("AcceptGambling.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->AcceptGambling->exists()) {
			throw new NotFoundException(__('Invalid accept_gambling'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['AcceptGambling']['id']=$id;		
			$pre_title_check = $this->AcceptGambling->find("count",array("conditions"=>array("AcceptGambling.title"=>$this->request->data['AcceptGambling']['title'],"AcceptGambling.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->AcceptGambling->saveAll($this->request->data['AcceptGambling'])) {
					$this->Session->setFlash(__('Accept Gambling has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Accept Gambling could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Accept Gambling title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->AcceptGambling->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->AcceptGambling->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->AcceptGambling->id = $id;
		if (!$this->AcceptGambling->exists()) {
			throw new NotFoundException(__('Invalid Accept Gambling'));
		}
		else
		{
			if ($this->AcceptGambling->delete()) {
				$this->Session->setFlash(__('Accept Gambling has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Accept Gambling could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
