<?php
App::uses('AppModel', 'Model');
class Deal extends AppModel {
	var $name = 'Deal';
	
	public $validate = array(
		 'deal_name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter deal name.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checkdeal_name',
					'deal_name'
			     ) ,
			     'message' => 'deal name is already in use.',
			),
		),
		 'temp_deal_name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => 'Please enter temp deal name.',
			),
			'rule1' => array(
			    'rule' => array(
					'_checktemp_deal_name',
					'temp_deal_name'
			     ) ,
			     'message' => 'temp deal name is already in use.',
			),
		),
	);
	
	function _checkdeal_name($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['Deal.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['Deal.deal_name'] =  $this->data[$this->name][$field2];
		$check_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($check_count>0)
			return false;
		return true;
	}
	function _checktemp_deal_name($field1 = array() , $field2 = null) 
	{
		if(isset($this->data[$this->name]['id']) && $this->data[$this->name]['id']!='') {
			$conditions['Deal.id <>'] = $this->data[$this->name]['id'];
		}
		$conditions['Deal.temp_deal_name'] =  $this->data[$this->name][$field2];
		$check_count = $this->find('count', array(
			'conditions' => $conditions ,
			'recursive' => -1
		));
		if($check_count>0)
			return false;
		return true;
	}
}
