<?php
App::uses('AppController', 'Controller');
class EmployeesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Employee','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Employee.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->Employee->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->Employee->updateAll(array("Employee.status"=>'0'),array("Employee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->Employee->updateAll(array("Employee.status"=>'1'),array("Employee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->Employee->updateAll(array("Employee.show_home"=>'1'),array("Employee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->Employee->updateAll(array("Employee.show_home"=>'0'),array("Employee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->Employee->deleteAll(array('Employee.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Employee']['title']) && $this->data['Employee']['title']!='') $title = $this->data['Employee']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['Employee']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['Employee.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Employee.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('employees', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add Employee'));
		if ($this->request->is('post')) {
			$this->Employee->create();	
			$pre_title_check = $this->Employee->find("count",array("conditions"=>array("Employee.title"=>$this->request->data['Employee']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['Employee']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->Employee->save($this->request->data['Employee'])){
					$this->Session->setFlash(__('Employee has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Employee could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Employee title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit Employee'));
		$this->Employee->id = $id;
		$selected = "";
		
		$driver_detail = $this->Employee->find("first",array("conditions"=>array("Employee.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->Employee->exists()) {
			throw new NotFoundException(__('Invalid employee'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['Employee']['id']=$id;		
			$pre_title_check = $this->Employee->find("count",array("conditions"=>array("Employee.title"=>$this->request->data['Employee']['title'],"Employee.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->Employee->saveAll($this->request->data['Employee'])) {
					$this->Session->setFlash(__('Employee has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Employee could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Employee title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->Employee->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->Employee->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->Employee->id = $id;
		if (!$this->Employee->exists()) {
			throw new NotFoundException(__('Invalid Employee'));
		}
		else
		{
			if ($this->Employee->delete()) {
				$this->Session->setFlash(__('Employee has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Employee could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
