<?php
class EmailTemplatesController extends AppController{
	
	public $name = 'Emailtemplate';	
	public $uses = array('EmailTemplate');
	public $helpers = array('Html', 'Session','Fck','Text', 'Js','Common');
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'EmailTemplate.id' => 'desc'
        )
    );
	
	public function admin_index()
	{
		$this->checkAdmin();
		$this->layout='admin';
		$this->set('title_for_layout', __('Email Templates'));
		
		$this->EmailTemplate->recursive = 0;
		
		if(isset($this->data['EmailTemplate']['name']) && $this->data['EmailTemplate']['name']!='') $name = $this->data['EmailTemplate']['name'];	
		else if(isset($this->params['named']['name']) && $this->params['named']['name']!='') $name = $this->request->data['EmailTemplate']['name']=$this->params['named']['name'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($name))
		{
			$conditions['EmailTemplate.name LIKE '] = '%'.$name.'%';
			$pagingArgs['name'] = $name;
		}
		
		/*$this->paginate = array('limit'=>20);*/
		$this->set("pagingArgs",$pagingArgs);
		$this->set('EmailTemplate', $this->paginate('EmailTemplate',$conditions));
	}
	public function admin_view($id=NULL)
	{
		$this->set('title_for_layout', __('Email Templates Detail'));
		$this->checkAdmin();
		if (!$id) {
			$this->Session->setFlash(__('Invalid emailtemplate', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('emailtemplate', $this->EmailTemplate->read(null, $id));
	}
	public function admin_add()
	{
		$this->set('title_for_layout', __('Add Email Templates'));
		$this->checkAdmin();
		$this->layout='admin';
		if (!empty($this->data)) {
			if ($this->EmailTemplate->save($this->data)) {
				$this->Session->setFlash(__('The email template has been saved'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'admin_index'));
			} else {
				$this->Session->setFlash(__('The email template could not saved'), 'default', array('class' => 'error'));
			}
		}
	}
	function admin_edit($id = null) {
		$this->set('title_for_layout', __('Edit Email Templates'));
		$this->checkAdmin();
		$this->layout='admin';
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid email template'), 'default', array('class' => 'success'));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			$this->request->data['EmailTemplate']['id']=$id;
			if ($this->EmailTemplate->save($this->data)) {
				$this->Session->setFlash(__('The email template has been saved'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'admin_index'));
			} else {
				$this->Session->setFlash(__('The email template could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->EmailTemplate->read(null, $id);
		}
		if($id!=''){
			$this->request->data = $this->EmailTemplate->find('first',array("conditions"=>array("EmailTemplate.id"=>$id)));
			$tempname = $this->EmailTemplate->find('first',array("conditions"=>array("EmailTemplate.id"=>$id),"fields"=>array("EmailTemplate.name")));
			$this->set('tempname',$tempname);
		}
		
	}
	function admin_delete($id = null) {
		$this->checkAdmin();
		$this->autoRender=false;
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for email template'), 'default', array('class' => 'error'));
			$this->redirect(array('action'=>'admin_index'));
		}
		if ($this->EmailTemplate->delete($id)) {
			$this->Session->setFlash(__('Email Template deleted'), 'default', array('class' => 'success'));
			$this->redirect(array('action'=>'admin_index'));
		}
		$this->Session->setFlash(__('Email Template could not be deleted'), 'default', array('class' => 'error'));
		$this->redirect(array('action' => 'admin_index'));
	}
}
?>