<?php
App::uses('AppController', 'Controller');
class DealsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Deal','EmailTemplate','ApplicationSetting','DealFile','DealInput','Site','Language','DealWriterName','DealUniqueId','Operator'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Deal.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->Deal->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->Deal->updateAll(array("Deal.status"=>'0'),array("Deal.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->Deal->updateAll(array("Deal.status"=>'0'),array("Deal.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->Deal->deleteAll(array('Deal.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Deal']['client_id']) && $this->data['Deal']['client_id']!='') $client_id = $this->data['Deal']['client_id'];	
		else if(isset($this->params['named']['client_id']) && $this->params['named']['client_id']!='') $client_id = $this->request->data['Deal']['client_id']=$this->params['named']['client_id'];
		
		if(isset($this->data['Deal']['deal_status_id']) && $this->data['Deal']['deal_status_id']!='') $deal_status_id = $this->data['Deal']['deal_status_id'];	
		else if(isset($this->params['named']['deal_status_id']) && $this->params['named']['deal_status_id']!='') $deal_status_id = $this->request->data['Deal']['deal_status_id']=$this->params['named']['deal_status_id'];
		
		if(isset($this->data['Deal']['deal_next_action_id']) && $this->data['Deal']['deal_next_action_id']!='') $deal_next_action_id = $this->data['Deal']['deal_next_action_id'];	
		else if(isset($this->params['named']['deal_next_action_id']) && $this->params['named']['deal_next_action_id']!='') $deal_next_action_id = $this->request->data['Deal']['deal_next_action_id']=$this->params['named']['deal_next_action_id'];
		
		if(isset($this->data['Deal']['deal_name']) && $this->data['Deal']['deal_name']!='') $deal_name = $this->data['Deal']['deal_name'];	
		else if(isset($this->params['named']['deal_name']) && $this->params['named']['deal_name']!='') $deal_name = $this->request->data['Deal']['deal_name']=$this->params['named']['deal_name'];
		
		if(isset($this->data['Deal']['temp_deal_name']) && $this->data['Deal']['temp_deal_name']!='') $temp_deal_name = $this->data['Deal']['temp_deal_name'];	
		else if(isset($this->params['named']['temp_deal_name']) && $this->params['named']['temp_deal_name']!='') $temp_deal_name = $this->request->data['Deal']['temp_deal_name']=$this->params['named']['temp_deal_name'];
		
		if(isset($this->data['Deal']['deal_type_id']) && $this->data['Deal']['deal_type_id']!='') $deal_type_id = $this->data['Deal']['deal_type_id'];	
		else if(isset($this->params['named']['deal_type_id']) && $this->params['named']['deal_type_id']!='') $deal_type_id = $this->request->data['Deal']['deal_type_id']=$this->params['named']['deal_type_id'];
		
		if(isset($this->data['Deal']['deal_payment_id']) && $this->data['Deal']['deal_payment_id']!='') $deal_payment_id = $this->data['Deal']['deal_payment_id'];	
		else if(isset($this->params['named']['deal_payment_id']) && $this->params['named']['deal_payment_id']!='') $deal_payment_id = $this->request->data['Deal']['deal_payment_id']=$this->params['named']['deal_payment_id'];
		
		if(isset($this->data['Deal']['unique_id']) && $this->data['Deal']['unique_id']!='') $unique_id = $this->data['Deal']['unique_id'];	
		else if(isset($this->params['named']['unique_id']) && $this->params['named']['unique_id']!='') $unique_id = $this->request->data['Deal']['unique_id']=$this->params['named']['unique_id'];
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($client_id))
		{
			$conditions['Deal.client_id'] = $client_id;
			$pagingArgs['client_id'] = $client_id;
		}
		if(!empty($deal_status_id))
		{
			$conditions['Deal.deal_status_id'] = $deal_status_id;
			$pagingArgs['deal_status_id'] = $deal_status_id;
		}
		if(!empty($deal_next_action_id))
		{
			$conditions['Deal.deal_next_action_id'] = $deal_next_action_id;
			$pagingArgs['deal_next_action_id'] = $deal_next_action_id;
		}		
		if(!empty($deal_name))
		{
			$conditions['Deal.deal_name LIKE '] = '%'.$deal_name.'%';
			$pagingArgs['deal_name'] = $deal_name;
		}	
		if(!empty($temp_deal_name))
		{
			$conditions['Deal.temp_deal_name LIKE '] = '%'.$temp_deal_name.'%';
			$pagingArgs['temp_deal_name'] = $temp_deal_name;
		}
		if(!empty($deal_type_id))
		{
			$conditions['Deal.deal_type_id'] = $deal_type_id;
			$pagingArgs['deal_type_id'] = $deal_type_id;
		}
		if(!empty($deal_payment_id))
		{
			$conditions['Deal.deal_payment_id'] = $deal_payment_id;
			$pagingArgs['deal_payment_id'] = $deal_payment_id;
		}
		if(!empty($unique_id))
		{
			$unique_id_details=$this->DealUniqueId->find("first",array("conditions"=>array("DealUniqueId.unique_id"=>$unique_id)));
			$conditions['Deal.id'] = $unique_id_details['DealUniqueId']['deal_id'];
			$pagingArgs['unique_id'] = $unique_id;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Deal.id'=>'DESC'),
			  'fields'=>array("deal_name","Deal.id","deal_amount","Deal.client_id","Deal.temp_deal_name","Deal.deal_next_action_id","Deal.status","Deal.deal_language","Deal.deal_date"),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deals', $rows);
		$deal_list_arr=$temp_deal_list_arr=array(""=>"");
		$deal_lists=$this->Deal->find("all",array("order"=>"deal_name","fields"=>array("deal_name","temp_deal_name")));
		foreach($deal_lists as $deal_list)
		{
			$deal_name=$deal_list['Deal']['deal_name'];
			$deal_list_arr[$deal_name]=$deal_name;
			
			$temp_deal_name=$deal_list['Deal']['temp_deal_name'];
			$temp_deal_list_arr[$temp_deal_name]=$temp_deal_name;
		}
		$this->set('deal_list_arr', $deal_list_arr);
		$this->set('temp_deal_list_arr', $temp_deal_list_arr);
		
		$operator_detail=$this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$this->Auth->user('id'))));
		$this->set('operator_detail', $operator_detail['Operator']);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add Deal'));
		if ($this->request->is('post')) {
			$this->Deal->create();	
				$this->request->data['Deal']['date_time']	=	date("Y-m-d H:i:s");
				$this->request->data['Deal']['status']		=	1;
				if ($res=$this->Deal->save($this->request->data['Deal'])){
					// save uploaded files
					foreach($this->request->data['DealFile']['filename'] as $dealfiles)
					{
						if(!empty($dealfiles['name']))
						{
							$imagedata = $dealfiles;
							$img=$this->uploadfile($imagedata,'deal_files',"DealFile",'filename');
							$file_arr1['id']='';
							$file_arr1['deal_id']=$res['Deal']['id'];
							$file_arr1['filename']=$img;
							$res_provide=$this->DealFile->save($file_arr1);
						}
					}
					// save uploaded files
					if(!empty($this->request->data['DealInput']['input_csv']['name']))
					{
						$imagedata = $this->request->data['DealInput']['input_csv'];
						$img=$this->uploadfile($imagedata,'deal_inputs',"Deal",'deal_input');
						$file_arr2['id']=$res['Deal']['id'];
						$file_arr2['deal_input']=$img;
						$res_provide=$this->Deal->save($file_arr2);
						
						if (($handle = fopen($this->request->data['DealInput']['input_csv']['tmp_name'], "r")) !== FALSE) {
								$count=1;
								while (($data = fgetcsv($handle, 1000000, ",")) !== FALSE) {
								if($count==1)
								{
									$count++;
									continue;
								}
								$siteurl=trim($data[0]);
								$anchor=trim($data[1]);
								$link_to=trim($data[2]);								
								$currency_id=$this->get_currency_id(trim($data[3]));								
								$article_price=trim($data[4]);								
								$article_duration_id=$this->get_article_duration_id(trim($data[5]));
								$language_id=$this->get_language_id(trim($data[6]));
								$topic=trim($data[7]);
								$anchor1=trim($data[8]);
								$link_to1=trim($data[9]);
								
								$siteurl=trim($siteurl,'/');
								$site_added=$siteurl;
								$siteurl=str_replace('http://','',$siteurl);
								$siteurl=str_replace('www','',$siteurl);
								$check_unique=$this->Site->find("first",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
								$check_count=$this->Site->find("count",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
								if($check_count > 1)
								{
									$error[]=$siteurl .' => '.$check_count;
								}
								if(empty($check_unique))
								{
									$error[]=$siteurl .' is not available. ';
								}
								else
								{
									$arr['id']='';
									$arr['deal_id']=$res['Deal']['id'];
									$arr['site']=$site_added;
									$arr['anchor']=$anchor;
									$arr['link_to']=$link_to;
									$arr['anchor1']=$anchor1;
									$arr['link_to1']=$link_to1;
									$arr['topic']=$topic;
									$arr['currency_id']=$currency_id;
									$arr['article_price']=$article_price;
									$arr['article_duration_id']=$article_duration_id;
									$arr['language_id']=$language_id;
									$arr['provider_currency_id']=$check_unique['Site']['currency_id'];
									$arr['provider_price']=$check_unique['Site']['article_price'];
									$arr['provider_payment_status_id']=1;
									$arr['source_email_id']=$check_unique['Site']['source_email_id'];
									$arr['link_status_id']=1;
									$arr['live_article_url']='';
									$arr['live_article_start_date']='';
									$arr['live_article_end_date']='';
									$arr['provider_paypal_id']='';
									$arr['link_comments']='';
									$this->DealInput->save($arr);
								}
							}
						}
					}
					$this->Session->setFlash(__('Deal has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'add'));
				} else {
					$error_arr=$this->Deal->validationErrors;
					if(isset($error_arr['deal_name'][0]))
						$this->Session->setFlash(__($error_arr['deal_name'][0]), 'default', array('class' => 'error'));
					else if(isset($error_arr['temp_deal_name'][0]))
						$this->Session->setFlash(__($error_arr['temp_deal_name'][0]), 'default', array('class' => 'error'));
					else
						$this->Session->setFlash(__('Deal could not be added.'), 'default', array('class' => 'error'));
					//$this->redirect(array('action' => 'index'));
				}			
		}
		$operator_detail=$this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$this->Auth->user('id'))));
		$this->set('operator_detail', $operator_detail['Operator']);
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit Deal'));
		$this->Deal->id = $id;
		$selected = "";
		
		$driver_detail = $this->Deal->find("first",array("conditions"=>array("Deal.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->Deal->exists()) {
			throw new NotFoundException(__('Invalid deal'));
		}
		$deal_input_condition['DealInput.deal_id']=$id;
		$deal_input_search=array();
		if ($this->request->is('post') || $this->request->is('put')) {
			if(isset($this->request->data['Deal']))
			{
				$this->request->data['Deal']['id']=$id;		
				if ($res=$this->Deal->saveAll($this->request->data['Deal'])) {
					
					foreach($this->request->data['DealFile']['filename'] as $dealfiles)
					{
						if(!empty($dealfiles['name']))
						{
							$imagedata = $dealfiles;
							$img=$this->uploadfile($imagedata,'deal_files',"DealFile",'filename');
							$file_arr1['id']='';
							$file_arr1['deal_id']=$id;
							$file_arr1['filename']=$img;
							$res_provide=$this->DealFile->save($file_arr1);
						}
					}				
					
					if(!empty($this->request->data['DealInput']['input_csv']['name']))
					{
						$imagedata = $this->request->data['DealInput']['input_csv'];
						$img=$this->uploadfile($imagedata,'deal_inputs',"Deal",'deal_input');
						$file_arr2['id']=$id;
						$file_arr2['deal_input']=$img;
						$res_provide=$this->Deal->save($file_arr2);
						
						if (($handle = fopen($this->request->data['DealInput']['input_csv']['tmp_name'], "r")) !== FALSE) {
								$count=1;
								while (($data = fgetcsv($handle, 1000000, ",")) !== FALSE) {
								if($count==1)
								{
									$count++;
									continue;
								}
								$siteurl=trim($data[0]);
								$site_added=$siteurl;
								$anchor=trim($data[1]);
								$link_to=trim($data[2]);								
								$currency_id=$this->get_currency_id(trim($data[3]));								
								$article_price=trim($data[4]);								
								$article_duration_id=$this->get_article_duration_id(trim($data[5]));
								$language_id=$this->get_language_id(trim($data[6]));
								$topic=trim($data[7]);
								$anchor1=trim($data[8]);
								$link_to1=trim($data[9]);
								
								$siteurl=trim($siteurl,'/');
								$siteurl=str_replace('http://','',$siteurl);
								$siteurl=str_replace('www','',$siteurl);
								$check_unique=$this->Site->find("first",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
								$check_count=$this->Site->find("count",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
								if($check_count > 1)
								{
									$error[]=$siteurl .' => '.$check_count;
								}
								if(empty($check_unique))
								{
									$error[]=$siteurl .' is not available. ';
								}
								else
								{
									$arr['id']='';
									$arr['deal_id']=$id;
									$arr['site']=$site_added;
									$arr['anchor']=$anchor;
									$arr['link_to']=$link_to;
									$arr['anchor1']=$anchor1;
									$arr['link_to1']=$link_to1;
									$arr['topic']=$topic;
									$arr['currency_id']=$currency_id;
									$arr['article_price']=$article_price;
									$arr['article_duration_id']=$article_duration_id;
									$arr['language_id']=$language_id;
									$arr['provider_currency_id']=$check_unique['Site']['currency_id'];
									$arr['provider_price']=$check_unique['Site']['article_price'];
									$arr['provider_payment_status_id']=1;
									$arr['source_email_id']=$check_unique['Site']['source_email_id'];
									$arr['link_status_id']=1;
									$arr['live_article_url']='';
									$arr['live_article_start_date']='';
									$arr['live_article_end_date']='';
									$arr['provider_paypal_id']='';
									$arr['link_comments']='';
									$this->DealInput->save($arr);
								}
							}
						}
					}
						
						
					$this->Session->setFlash(__('Deal has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal could not be updated.'), 'default', array('class' => 'error'));
				}
			}
			else
			{
				if(isset($_REQUEST['deal_input_submit']) || !empty($this->request->data['DealInput']['word_output_id']))
				{
					if(!empty($this->request->data['DealInput']['link_status_id_deal']))
					{
						$this->DealInput->updateAll(array("DealInput.link_status_id"=>$this->request->data['DealInput']['link_status_id_deal']),array("DealInput.id"=>$this->request->data['frmList']['ID']));
						$this->Session->setFlash(__('Link Status has been changed.'), 'default', array('class' => 'success'));
					}
					if(!empty($this->request->data['DealInput']['deal_writer_name_id']))
					{
						$this->DealInput->updateAll(array("DealInput.deal_writer_name_id"=>$this->request->data['DealInput']['deal_writer_name_id']),array("DealInput.id"=>$this->request->data['frmList']['ID']));
						$this->Session->setFlash(__('Writer Name has been changed.'), 'default', array('class' => 'success'));
					}
					
					if(!empty($this->request->data['DealInput']['word_output_id']))
					{
						$find_last_id=$this->DealUniqueId->find("first",array("order"=>"id desc"));
						if(empty($find_last_id))
							$unique_id='LKDJS1';
						else
							$unique_id='LKDJS'.($find_last_id['DealUniqueId']['id']+1);
						// insert into DealUniqueId
						$deal_input_ids_imp=implode(",",$this->request->data['frmList']['ID']);
						$deal_unique_id_arr['id']='';
						$deal_unique_id_arr['deal_id']=$id;
						$deal_unique_id_arr['unique_id']=$unique_id;
						$deal_unique_id_arr['deal_input_ids']=$deal_input_ids_imp;
						$deal_unique_id_arr['date_time']=date("Y-m-d H:i:s");
						$res_unique=$this->DealUniqueId->save($deal_unique_id_arr);
						
						$namedate=__("Word-output")."-".date("m.d.y");
						header("Content-type: application/vnd.ms-word");
						header("Content-Disposition: attachment;Filename=".$namedate.".doc");
						
						echo "<html>";
						echo "<body>";
						echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-1252\">";
						$get_client_detail=$this->get_client_detail($driver_detail['Deal']['client_id']);
						echo '<p style="text-align:center"><b>'.$unique_id.'</b></p>';
						echo '<p>'.nl2br($get_client_detail['links_instructions']).'</p>';
						$count=1;
						foreach($this->request->data['frmList']['ID'] as $deal_input_id)
						{
							$get_deal_input_detail=$this->get_deal_input_detail($deal_input_id);
							$topic=$get_deal_input_detail['DealInput']['topic'];
							echo "<p><b>Article ".$count." :</b></p>";
							if(!empty($topic))
								echo '<p>Topic : '.$topic.'</p>';
							else
								echo '<p>Topic : Article to be publish '.$get_deal_input_detail['DealInput']['site'].' on '.$get_deal_input_detail['DealInput']['live_article_start_date'].'  so write article matched to site theme</p>'; 
							echo '<p>Links to : <a href="'.$get_deal_input_detail['DealInput']['link_to'].'">'.$get_deal_input_detail['DealInput']['link_to'].'</a></p>';
							echo '<p>anchor : '.$get_deal_input_detail['DealInput']['anchor'].'</p>';
							if(!empty($get_deal_input_detail['DealInput']['link_to1']))
								echo '<p>Links to 1 : <a href="'.$get_deal_input_detail['DealInput']['link_to1'].'">'.$get_deal_input_detail['DealInput']['link_to1'].'</a></p>';
							if(!empty($get_deal_input_detail['DealInput']['anchor1']))
								echo '<p>anchor 1: '.$get_deal_input_detail['DealInput']['anchor1'].'</p>';
							echo '<p></p><p></p>';
							$count++;
					  	}
						echo "</body>";
						echo "</html>";
					  fclose($handle);
					}
					unset($this->request->data['DealInput']['link_status_id']);
					unset($this->request->data['DealInput']['deal_writer_name_id']);
					unset($this->request->data['DealInput']['link_status_id_deal']);
				}
				else if(isset($_REQUEST['deal_input_submit']) || !empty($this->request->data['DealInput']['csv_output_id']))
				{
					if(!empty($this->request->data['DealInput']['link_status_id_deal']))
					{
						$this->DealInput->updateAll(array("DealInput.link_status_id"=>$this->request->data['DealInput']['link_status_id_deal']),array("DealInput.id"=>$this->request->data['frmList']['ID']));
						$this->Session->setFlash(__('Link Status has been changed.'), 'default', array('class' => 'success'));
					}
					if(!empty($this->request->data['DealInput']['deal_writer_name_id']))
					{
						$this->DealInput->updateAll(array("DealInput.deal_writer_name_id"=>$this->request->data['DealInput']['deal_writer_name_id']),array("DealInput.id"=>$this->request->data['frmList']['ID']));
						$this->Session->setFlash(__('Writer Name has been changed.'), 'default', array('class' => 'success'));
					}
					if(!empty($this->request->data['DealInput']['csv_output_id']))
					{
						$namedate=__("Deal-Input")."-".date("m.d.y");
						$file_type = "vnd.ms-excel";
						$file_ending = "csv";
						header("Content-Type: application/$file_type");
						header("Content-Disposition: attachment; filename=$namedate.$file_ending");
						header("Pragma: no-cache");
						header("Expires: 0");
						$title = __("Deal Input");
						$sep = ", ";
						$array_key=array(__("Link Status"),__("Live Article Url"),__("Site"),__("Anchor"),__("Links To"),__("Currency"),__("Article Price"),__("Article Duration"),__("Language"),__("Anchor 2"),__("Links To 2"),__("Topic"));
						//start of printing column names as names of MySQL fields
						for ($i = 0; $i < count($array_key); $i++)
						{
							echo $array_key[$i] . ", ";
						}
						print("\n");
						foreach($this->request->data['frmList']['ID'] as $deal_input_id)
						{
							$get_deal_input_detail=$this->get_deal_input_detail($deal_input_id);
							$link_status=$this->get_link_status($get_deal_input_detail['DealInput']['link_status_id']);
							$currency=$this->get_currency($get_deal_input_detail['DealInput']['currency_id']);
							$article_duration=$this->get_article_duration($get_deal_input_detail['DealInput']['article_duration_id']);
							$language=$this->get_language($get_deal_input_detail['DealInput']['language_id']);
							
							$schema_insert = "";
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$link_status)).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['live_article_url'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['site'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['anchor'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['link_to'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$currency)).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['article_price'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$article_duration)).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$language)).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['topic'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['anchor1'])).$sep;
							$schema_insert .= str_replace(',',';',str_replace(',',' ',$get_deal_input_detail['DealInput']['link_to1'])).$sep;
							$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
							$schema_insert .= "\t";
							print(trim($schema_insert));
							print "\n";
						}
						exit;
					}
					unset($this->request->data['DealInput']['link_status_id']);
					unset($this->request->data['DealInput']['deal_writer_name_id']);
				}
				else if(isset($_REQUEST['deal_input_submit']) || !empty($this->request->data['DealInput']['delete_all_id']))
				{
					$this->DealInput->deleteAll(array('DealInput.id' => $this->request->data['frmList']['ID']), false);
					$this->Session->setFlash(__('Selected Deal inputs have been deleted.'), 'default', array('class' => 'success'));
				}
				//echo '<pre>';print_r($this->request->data['DealInput']);die;
				if(isset($this->request->data['DealInput']['language_id']) && $this->request->data['DealInput']['language_id']!='') $language_id = $this->request->data['DealInput']['language_id'];	
				else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['DealInput']['language_id']=$this->params['named']['language_id'];
				
				if(isset($this->request->data['DealInput']['provider_payment_status_id']) && $this->request->data['DealInput']['provider_payment_status_id']!='') $provider_payment_status_id = $this->request->data['DealInput']['provider_payment_status_id'];	
				else if(isset($this->params['named']['provider_payment_status_id']) && $this->params['named']['provider_payment_status_id']!='') $provider_payment_status_id = $this->request->data['DealInput']['provider_payment_status_id']=$this->params['named']['provider_payment_status_id'];
				
				if(isset($this->request->data['DealInput']['link_status_id']) && $this->request->data['DealInput']['link_status_id']!='') $link_status_id = $this->request->data['DealInput']['link_status_id'];	
				else if(isset($this->params['named']['link_status_id']) && $this->params['named']['link_status_id']!='') $link_status_id = $this->request->data['DealInput']['link_status_id']=$this->params['named']['link_status_id'];
				
				if(isset($this->request->data['DealInput']['source_email_id']) && $this->request->data['DealInput']['source_email_id']!='') $source_email_id = $this->request->data['DealInput']['source_email_id'];	
				else if(isset($this->params['named']['source_email_id']) && $this->params['named']['source_email_id']!='') $source_email_id = $this->request->data['DealInput']['source_email_id']=$this->params['named']['source_email_id'];
				
				if(isset($this->request->data['DealInput']['unique_id']) && $this->request->data['DealInput']['unique_id']!='') $unique_id = $this->request->data['DealInput']['unique_id'];	
				else if(isset($this->params['named']['unique_id']) && $this->params['named']['unique_id']!='') $unique_id = $this->request->data['DealInput']['unique_id']=$this->params['named']['unique_id'];
				
				if(isset($this->request->data['DealInput']['site']) && $this->request->data['DealInput']['site']!='') $site = $this->request->data['DealInput']['site'];	
				else if(isset($this->params['named']['site']) && $this->params['named']['site']!='') $site = $this->request->data['DealInput']['site']=$this->params['named']['site'];
				
				if(!empty($language_id))
				{
					$deal_input_condition['DealInput.language_id'] = $language_id;
					$deal_input_search['language_id']=$language_id;
				}
				if(!empty($provider_payment_status_id))
				{
					$deal_input_condition['DealInput.provider_payment_status_id'] = $provider_payment_status_id;
					$deal_input_search['provider_payment_status_id']=$provider_payment_status_id;
				}
				if(!empty($link_status_id))
				{
					$deal_input_condition['DealInput.link_status_id'] = $link_status_id;
					$deal_input_search['link_status_id']=$link_status_id;
				}
				if(!empty($source_email_id))
				{
					$deal_input_condition['DealInput.source_email_id'] = $source_email_id;
					$deal_input_search['source_email_id']=$source_email_id;
				}
				if(!empty($unique_id))
				{
					$unique_id_details=$this->DealUniqueId->find("first",array("conditions"=>array("DealUniqueId.unique_id"=>$unique_id)));
					$deal_input_ids = $unique_id_details['DealUniqueId']['deal_input_ids'];
					$exp=explode(",",$deal_input_ids);
					if(count($exp) > 1)
						$deal_input_condition['DealInput.id'] = $exp;
					else
						$deal_input_condition['DealInput.id'] = $deal_input_ids;
					$deal_input_search['unique_id']=$unique_id;
				}
				if(!empty($site))
				{
					$deal_input_condition['DealInput.site LIKE '] = '%'.$site.'%';
					$deal_input_search['site']=$site;
				}
			}			
		}
		//echo '<pre>';print_r($deal_input_condition);print_r($this->request->data['DealInput']);die;
		$deal_data = $this->Deal->read(null, $id);
		$this->request->data['Deal']=$deal_data['Deal'];
		$this->request->data['DealFile']=$deal_input_search;
		
		$deal_files=$this->DealFile->find("all",array("conditions"=>array("DealFile.deal_id"=>$id)));
		$this->set("deal_files",$deal_files);
		
		$deal_inputs=$this->DealInput->find("all",array("conditions"=>$deal_input_condition));
		$deal_inputs_laguages=$this->DealInput->find("all",array("conditions"=>array('DealInput.deal_id'=>$id),"fields"=>array("DealInput.id","DealInput.language_id")));
		
		$link_status_id_arr=array();
		foreach($deal_inputs as $dn_val)
		{
			$tmp_link_status_id=$dn_val['DealInput']['link_status_id'];
			$tmp_key=$link_status_id_arr[$tmp_link_status_id];
			if(empty($tmp_key))
				$tmp_key=0;
			$link_status_id_arr[$tmp_link_status_id]=$tmp_key+1;
		}
		
		$this->set("link_status_id_arr",$link_status_id_arr);
		
		$language_arr=array();
		foreach($deal_inputs_laguages as $deal_inputs_laguage)
		{
			$l_id=$deal_inputs_laguage['DealInput']['language_id'];
			if(!in_array($l_id,$language_arr))
				$language_arr[]=$deal_inputs_laguage['DealInput']['language_id'];
		}
		if(count($language_arr) > 1)
			$languages=$this->Language->find("all",array("conditions"=>array("Language.id"=>$language_arr)));
		else
			$languages=$this->Language->find("all",array("conditions"=>array("Language.id"=>$language_arr[0])));
		$language_list=array(""=>"Select Language");
		$deal_writer_id_list=array();
		foreach($languages as $language)
		{
			$lan_id=$language['Language']['id'];
			$language_list[$lan_id]=$language['Language']['title'];
			$deal_writer_arr=$this->DealWriterName->find("all",array("conditions"=>array("DealWriterName.language LIKE "=>'%'.$lan_id.'%')));
			//pr($deal_writer_arr);
			foreach($deal_writer_arr as $deal_writer_arr1)
			{
				if(!in_array($deal_writer_arr1['DealWriterName']['id'],$deal_writer_id_list))
					$deal_writer_id_list[]=$deal_writer_arr1['DealWriterName']['id'];
			}
		}
		if(count($deal_writer_id_list) > 1)
			$deal_writer_names=$this->DealWriterName->find("all",array("conditions"=>array("DealWriterName.id"=>$deal_writer_id_list)));
		else
			$deal_writer_names=$this->DealWriterName->find("all",array("conditions"=>array("DealWriterName.id"=>$deal_writer_id_list[0])));
		$deal_writer_name_list=array(""=>"Select link writer");
		foreach($deal_writer_names as $deal_writer_names)
		{
			$id=$deal_writer_names['DealWriterName']['id'];
			$deal_writer_name_list[$id]=$deal_writer_names['DealWriterName']['title'];
		}
		
		$this->set("deal_writer_name_list",$deal_writer_name_list);
		$this->set("language_list",$language_list);
		$this->set("deal_inputs",$deal_inputs);
		
		$this->set('selected', $selected);
		$operator_detail=$this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$this->Auth->user('id'))));
		$this->set('operator_detail', $operator_detail['Operator']);
	}
	public function admin_delete($id = null) {
		$this->checkLogin();
		$this->Deal->id = $id;
		if (!$this->Deal->exists()) {
			throw new NotFoundException(__('Invalid Deal'));
		}
		else
		{
			if ($this->Deal->delete()) {
				$this->Session->setFlash(__('Deal has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
	public function remove_deal_file($deal_file_id)
	{
		$this->checkLogin();
		$this->autoRender=false;
		$res=$this->DealFile->find("first",array("conditions"=>array("DealFile.id"=>$deal_file_id)));
		if(!empty($res))
		{
			if(file_exists(WWW_ROOT.'/deal_files'.$res['DealFile']['filename']))
				unlink(WWW_ROOT.'/deal_files'.$res['DealFile']['filename']);
			$this->DealFile->deleteAll(array('DealFile.id' =>$deal_file_id), false);
		}
		echo $deal_file_id;
	}
	public function admin_input_edit($id = null) {
		$this->checkLogin();
		$selected = "";
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealInput']['id']=$id;
			$this->DealInput->save($this->request->data['DealInput']);
			$this->Session->setFlash(__('Deal input has been updates successfully.'), 'default', array('class' => 'success'));
		}
		$operator_detail=$this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$this->Auth->user('id'))));
		$this->set('operator_detail', $operator_detail['Operator']);
		$this->request->data = $this->DealInput->read(null, $id);
	}
	public function admin_deal_input_delete($deal_input_id,$deal_id=NULL)
	{
		$this->checkLogin();
		$this->autoRender=false;
		$this->DealInput->deleteAll(array('DealInput.id' =>$deal_input_id), false);
		$this->redirect(array('action' => 'edit',$deal_id));
	}
	public function admin_deal_search_input_delete($deal_input_id,$deal_id=NULL)
	{
		$this->checkLogin();
		$this->autoRender=false;
		$this->DealInput->deleteAll(array('DealInput.id' =>$deal_input_id), false);
		$this->Session->setFlash(__('Deal input has been delete successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('controller'=>'deal_inputs','action' => 'search'));
	}	
	public function admin_search() {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->Deal->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->Deal->updateAll(array("Deal.status"=>'0'),array("Deal.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->Deal->updateAll(array("Deal.status"=>'0'),array("Deal.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->Deal->deleteAll(array('Deal.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Deal']['client_id']) && $this->data['Deal']['client_id']!='') $client_id = $this->data['Deal']['client_id'];	
		else if(isset($this->params['named']['client_id']) && $this->params['named']['client_id']!='') $client_id = $this->request->data['Deal']['client_id']=$this->params['named']['client_id'];
		
		if(isset($this->data['Deal']['deal_status_id']) && $this->data['Deal']['deal_status_id']!='') $deal_status_id = $this->data['Deal']['deal_status_id'];	
		else if(isset($this->params['named']['deal_status_id']) && $this->params['named']['deal_status_id']!='') $deal_status_id = $this->request->data['Deal']['deal_status_id']=$this->params['named']['deal_status_id'];
		
		if(isset($this->data['Deal']['deal_next_action_id']) && $this->data['Deal']['deal_next_action_id']!='') $deal_next_action_id = $this->data['Deal']['deal_next_action_id'];	
		else if(isset($this->params['named']['deal_next_action_id']) && $this->params['named']['deal_next_action_id']!='') $deal_next_action_id = $this->request->data['Deal']['deal_next_action_id']=$this->params['named']['deal_next_action_id'];
		
		if(isset($this->data['Deal']['deal_name']) && $this->data['Deal']['deal_name']!='') $deal_name = $this->data['Deal']['deal_name'];	
		else if(isset($this->params['named']['deal_name']) && $this->params['named']['deal_name']!='') $deal_name = $this->request->data['Deal']['deal_name']=$this->params['named']['deal_name'];
		
		if(isset($this->data['Deal']['deal_type_id']) && $this->data['Deal']['deal_type_id']!='') $deal_type_id = $this->data['Deal']['deal_type_id'];	
		else if(isset($this->params['named']['deal_type_id']) && $this->params['named']['deal_type_id']!='') $deal_type_id = $this->request->data['Deal']['deal_type_id']=$this->params['named']['deal_type_id'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($client_id))
		{
			$conditions['Deal.client_id'] = $client_id;
			$pagingArgs['client_id'] = $client_id;
		}
		if(!empty($deal_status_id))
		{
			$conditions['Deal.deal_status_id'] = $deal_status_id;
			$pagingArgs['deal_status_id'] = $deal_status_id;
		}
		if(!empty($deal_next_action_id))
		{
			$conditions['Deal.deal_next_action_id'] = $deal_next_action_id;
			$pagingArgs['deal_next_action_id'] = $deal_next_action_id;
		}		
		if(!empty($deal_name))
		{
			$conditions['Deal.deal_name LIKE '] = '%'.$deal_name.'%';
			$pagingArgs['deal_name'] = $deal_name;
		}
		if(!empty($deal_type_id))
		{
			$conditions['Deal.deal_type_id'] = $deal_type_id;
			$pagingArgs['deal_type_id'] = $deal_type_id;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Deal.id'=>'DESC'),
			  'fields'=>array("deal_name","Deal.id","deal_amount","Deal.client_id","Deal.temp_deal_name","Deal.status","Deal.deal_language","Deal.deal_date"),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deals', $rows);
	}
	public function admin_majestic()
	{
		$this->checkAdmin();
		$this->autoRender=false;
		
		$ffs = scandir($dir);

		unset($ffs[array_search('.', $ffs, true)]);
		unset($ffs[array_search('..', $ffs, true)]);
	
		// prevent empty ordered elements
		if (count($ffs) < 1)
			return;
		$arr=array();
		foreach($ffs as $ff){
			$title_arr=explode(".",$ff);
			$extenxion=end($title_arr);
			if($extenxion=='htm' || $extenxion=='html')
			{
				echo $dir.'/'.$ff;
				$htmlContent = file_get_contents("http://teskusman.esy.es/index.html");
		
				$DOM = new DOMDocument();
				$DOM->loadHTML($htmlContent);
				
				$Header = $DOM->getElementsByTagName('th');
				$Detail = $DOM->getElementsByTagName('td');
			
				//#Get header name of the table
				foreach($Header as $NodeHeader) 
				{
					$aDataTableHeaderHTML[] = trim($NodeHeader->textContent);
				}
				//print_r($aDataTableHeaderHTML); die();
			
				//#Get row data/detail table without header name as key
				$i = 0;
				$j = 0;
				foreach($Detail as $sNodeDetail) 
				{
					$aDataTableDetailHTML[$j][] = trim($sNodeDetail->textContent);
					$i = $i + 1;
					$j = $i % count($aDataTableHeaderHTML) == 0 ? $j + 1 : $j;
				}
				print_r($aDataTableDetailHTML); die();
			}
			if(is_dir($dir.'/'.$ff)) listFolderFiles($dir.'/'.$ff);
		}
	}
	public function admin_link_status($id = null) {
		$this->checkLogin();
		
		$deal_inputs = $this->DealInput->find("all",array("conditions"=>array("DealInput.deal_id"=>$id)));
		$deal_input_arr=$deal_input_name_arr=array();
		foreach($deal_inputs as $deal_input)
		{
			$tmp_id=$deal_input['DealInput']['link_status_id'];
			if (array_key_exists($tmp_id,$deal_input_arr))
				$deal_input_arr[$tmp_id]=$deal_input_arr[$tmp_id]+1;
			else
				$deal_input_arr[$tmp_id]=1;
		}
		$this->set('deal_input_arr', $deal_input_arr);
	}
}
